% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fun_calling_chain.r
\name{get_fun_calling_chain}
\alias{get_fun_calling_chain}
\title{Return the chain of calling functions}
\usage{
get_fun_calling_chain(n = NULL, showParameters = FALSE, silent = TRUE)
}
\arguments{
\item{n}{non-negative integer specifying the level of interest in the function calling chain,
where 0 means the function calling \code{get_fun_calling_chain}.
It defaults to \code{NULL}, in which case the full chain is returned.}

\item{showParameters}{flag indicating whether the parameters of the function call should also be shown
in the output.}

\item{silent}{whether to run in silent mode. If FALSE, the calling chain is shown in an intuitive way.
It defaults to \code{TRUE}.}
}
\value{
If \code{n=NULL} (the default) a data frame with the function calling chain information, 
with the following columns:
\itemize{
\item{\code{fun}:} the function name (including parameters if \code{showParameters=TRUE})
\item{\code{env}:} the function's enclosing enviroment, i.e. the environment where the function is defined
as returned by \code{environment(<function>)}
\item{\code{envfun}:} the environment where the function is defined together with the function name (and its parameters
if \code{showParameters=TRUE}) separated by a \code{$} sign. Ex: \code{env1$f()}
}
The rownames of the data frame are the stack level of the function calls in the chain,
from 0 up to the number of functions in the chain, where 0 indicates the current function
(i.e. the function that called \code{get_fun_calling_chain}).

The functions in the data frame are sorted from most recent to least recent call, much like the common
way of displaying the function stack in debug mode.

If the function is NOT called from within a function, \code{NULL} is returned.

If \code{n} is not NULL and is non-negative, the environment and the function name (including parameters
if \code{showParameters=TRUE}) separated by a \code{$} sign are returned (ex: \code{env1$f(x = 3, n = 1)}).

if \code{n < 0} or if \code{n} is larger than the function calling chain length, \code{NULL} is returned.
}
\description{
Return a data frame with the stack or chain of function calls, or optionally the information on one
particular function in this chain.
}

