% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_env_names.r
\name{get_env_names}
\alias{get_env_names}
\title{Create a lookup table with address-name pairs of environments}
\usage{
get_env_names(envir = NULL, include_functions = FALSE)
}
\arguments{
\item{envir}{environment where environments are searched for to construct the lookup table.
It defaults to \code{NULL} which means that all environments in the whole workspace should be searched for
and all packages in the \code{search()} path should be returned including their namespace environments.}

\item{include_functions}{flag indicating whether to include in the returned data frame 
user-defined environments defined inside function execution environments.}
}
\value{
A data frame containing the following six columns:
\itemize{
\item{\code{type}} type of environment ("user" for user-defined environments "system/package"
for system or package environments, and "namespace" for namespace environments).
\item{\code{location}} location of the environment, which is only non-\code{NA} for user-defined
and function execution environments: 
   \itemize{
   \item for a user-defined environment, the location is the system environment or package where
   the environment resides (note that this may be different from the parent environment if the
   parent environment was set during creation with the \code{parent=} option of the \code{new.env()}
   function or using the \code{parent.env()} function)
   \item for a function execution environment, the location is the function's enclosing environment, i.e. the environment
   where the function is defined.
   }
\item{\code{locationaddress}} for function execution environments, the memory address of the \code{location}
environment.
\item{\code{address}} memory address of the environment. This is the key piece of information used
by the package to retrieve the environment name with the \code{environment_name()} function.
For functions, this is the address of the function's execution environment.
\item{\code{pathname}} path to the environment and its name. This is the combination of columns
\code{path} and \code{name} whose values are put together separated by \code{$}.
\item{\code{path}} path to the environment (i.e. all environments that need to be traversed in order
to reach the environment).
\item{\code{name}} name of the environment.
}
The \code{type} column is used to distinguish between user-defined environments, function execution
environments, package or system environments, and namespace environments.

The data frame is empty if no environments are found in the given \code{envir} environment.

\code{NULL} is returned when an error occurs.
}
\description{
Return a data frame containing the address-name pairs of system, package, namespace, user-defined,
and function execution environments in the whole workspace or within a given environment.
}
\details{
The search for environments is recursive, meaning that a search is carried out for environments defined
within other user-defined environments and, when \code{include_functions=TRUE} within function execution
environments.

The search within packages is always on \emph{exported objects} only.

If \code{envir} is the global environment ,the lookup table includes all system,
package, and namespace environments in the \code{search()} path, as well as all user-defined and function execution
environments found in the global environment (with recursive search).

If \code{envir=NULL} the lookup table includes all system, package, and namespace environments
in the \code{search()} path, as well as all user-defined found in \emph{any} of those environments (with recursive search),
and all function execution environments.
}
\examples{
# Create example of chained environments
env1 <- new.env()
with(env1, env11 <- new.env())
with(env1$env11, envx <- new.env())

# Address-name pairs of all environments defined in the workspace,
# including environments in the search path
get_env_names()  # returns a data frame with at least the following user environments:
                 # "env1", "env1$env11", "env1$env11$envx"  

# Address-name pairs of the environments defined in a given user-defined environment
get_env_names(env1)  # returns a data frame with the following user environments:
                     # "env11", "env11$envx"

# Address-name pairs of the environments defined in a given package
get_env_names(as.environment("package:stats")) # should return an empty data frame
                                               # (since the stats package does not
                                               # have any environments defined)
}

