% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-database.DBconfig.R
\name{AddListRemoveSsffTrackDefinition}
\alias{AddListRemoveSsffTrackDefinition}
\alias{add_ssffTrackDefinition}
\alias{list_ssffTrackDefinitions}
\alias{remove_ssffTrackDefinition}
\title{Add / List / Remove ssffTrackDefinition to / from / of emuDB}
\usage{
add_ssffTrackDefinition(
  emuDBhandle,
  name,
  columnName = NULL,
  fileExtension = NULL,
  onTheFlyFunctionName = NULL,
  onTheFlyParams = NULL,
  onTheFlyOptLogFilePath = NULL,
  verbose = TRUE,
  interactive = TRUE
)

list_ssffTrackDefinitions(emuDBhandle)

remove_ssffTrackDefinition(emuDBhandle, name, deleteFiles = FALSE)
}
\arguments{
\item{emuDBhandle}{emuDB handle as returned by \code{\link{load_emuDB}}}

\item{name}{name of ssffTrackDefinition}

\item{columnName}{columnName of ssffTrackDefinition.
If the \code{onTheFlyFunctionName} parameter is set and columnName isn't, the
\code{columnName} will default to the first entry in \code{wrasspOutputInfos[[onTheFlyFunctionName]]$tracks}.}

\item{fileExtension}{fileExtension of ssffTrackDefinitions.
If the \code{onTheFlyFunctionName} parameter is set and fileExtension isn't, the
\code{fileExtension} will default to the first entry in \code{wrasspOutputInfos[[onTheFlyFunctionName]]$ext}.}

\item{onTheFlyFunctionName}{name of wrassp function to do on-the-fly calculation. If set to the name of a wrassp 
signal processing function, not only the emuDB schema is extended by the ssffTrackDefintion but also 
the track itself is calculated from the signal file and stored in the emuDB. See \code{names(wrasspOutputInfos)}
for a list of all the signal processing functions provided by the wrassp package.}

\item{onTheFlyParams}{a list of parameters that will be given to the function 
passed in by the onTheFlyFunctionName parameter. This list can easily be 
generated using the \code{\link{formals}} function on the according signal processing function 
provided by the wrassp package and then setting the
parameter one wishes to change.}

\item{onTheFlyOptLogFilePath}{path to optional log file for on-the-fly function}

\item{verbose}{Show progress bars and further information}

\item{interactive}{ask user for confirmation}

\item{deleteFiles}{delete files that belong to ssffTrackDefinition on removal}
}
\description{
Add / List / Remove ssffTrackDefinition to / from / of emuDB. 
An ssffTrack (often simply referred to as a track) references 
data that is stored in the Simple Signal File Format (SSFF) 
in the according bundle folders. The two most common types of data are:
\itemize{
\item{complementary data that was acquired during the recording 
such as data acquired during electromagnetic 
articulographic (EMA) or electropalatography (EPG) recordings;}
\item{derived data, i.e. data that was calculated from the original audio signal 
such as formant values and their bandwidths or the short-term Root Mean Square amplitude of the signal.}
}
For more information on the structural elements of an emuDB see \code{vignette(emuDB)}.
}
\examples{
\dontrun{

##################################
# prerequisite: loaded ae emuDB 
# (see ?load_emuDB for more information)

# add ssff track definition to ae emuDB
# calculating the according SSFF files (.zcr) on-the-fly
# using the wrassp function "zcrana" (zero-crossing-rate analysis)
add_ssffTrackDefinition(emuDBhandle = ae,
                        name = "ZCRtrack",
                        onTheFlyFunctionName = "zcrana")
                        
# add ssff track definition to ae emuDB
# for SSFF files that will be added later (either
# by adding files to the emuDB using 
# the add_files() function or by calculating
# them using the according function provided 
# by the wrassp package)
add_ssffTrackDefinition(emuDBhandle = ae,
                        name = "formants",
                        columnName = "fm",
                        fileExtension = "fms")

# list ssff track definitions for ae emuDB
list_ssffTrackDefinitions(emuDBhandle = ae)

# remove newly added ssff track definition (does not delete 
# the actual .zcr files)
remove_ssffTrackDefinition(emuDBhandle = ae,
                           name = "ZCRtrack")

}

}
