% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emdiObject.R
\name{emdiObject}
\alias{emdiObject}
\title{Fitted emdiObject}
\value{
The following components are always included in an emdi object:
\item{\code{call}}{a list containing an image of the function call that
                   produced the object.}
\item{\code{fixed}}{a formula of fixed effects used in the nested error linear
             regression (see also \code{fixed} in \code{\link{ebp}}).}
 \item{\code{framework}}{a list with following 8 components:}

 \tabular{rll}{
     \tab \code{N_dom_smp} \tab number of domains in the sample \cr
     \tab \code{N_dom_unobs} \tab number of out-of-sample domains \cr
     \tab \code{N_pop} \tab total number of units in population \cr
     \tab \code{N_smp} \tab total number of units in sample \cr
     \tab \code{pop_domains_vec} \tab an arranged vector
                    of the domain indicator variable \cr
     \tab \code{smp_data} \tab an arranged data set of sample data \cr
     \tab \code{smp_domains} \tab a character naming the
                    domain indicator variable (see also \code{smp_domains} in
                    \code{\link{ebp}}) \cr
     \tab \code{smp_domains_vec} \tab an arranged vector of
                    the domain indicator variable \cr
}
\item{\code{ind}}{data frame containing estimates for indicators per domain}
\item{\code{method}}{character returning the method for estimation of
   the optimal lambda, here "reml"}
\item{\code{model}}{an object returned by the lme function of type "lme" 
   and representing a fitted linear mixed-effects model (for
   further explanations see \code{\link[nlme]{lme}} and
   \code{\link[nlme]{lmeObject}}).}
\item{\code{MSE}}{data frame containing MSE estimates corresponding to the
point predictions in \code{ind} per indicator per domain if MSE is selected
to be TRUE in function call. If FALSE, \code{MSE} is NULL.}
\item{\code{transformation}}{character returning the selected transformation
type (see also \code{transformation} in \code{\link{ebp}}).}
\item{\code{transform_param}}{a list with two elements, \code{optimal_lambda}
   and \code{shift_par}, where the first contains the optimal parameter for a
   Box-Cox transformation or NULL for no and log transformation and the
   second the potential shift parameter in the log or Box-Cox transformation
   and NULL for no transformation.}
}
\description{
An object of class "emdi" that represents point predictions of regional 
disaggregated indicators. Optionally it also contains corresponding MSE 
estimates. Objects of this class have methods for the generic functions 
\code{\link{estimators}}, \code{\link{print}}, \code{\link{plot}},
and \code{\link{summary}}.
}
\references{
Molina, I. and Rao, J.N.K. (2010). Small area estimation of poverty
indicators. The Canadian Journal of Statistics, Vol. 38, No.3, 369-385.
}
\seealso{
\code{\link{ebp}}, \code{ \link[nlme]{lme}},
\code{ \link[nlme]{lmeObject}}
}

