% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umap.R
\name{step_umap}
\alias{step_umap}
\title{Supervised and unsupervised uniform manifold approximation and projection
(UMAP)}
\usage{
step_umap(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  outcome = NULL,
  neighbors = 15,
  num_comp = 2,
  min_dist = 0.01,
  metric = "euclidean",
  learn_rate = 1,
  epochs = NULL,
  options = list(verbose = FALSE, n_threads = 1),
  seed = sample(10^5, 2),
  prefix = "UMAP",
  keep_original_cols = FALSE,
  retain = deprecated(),
  object = NULL,
  skip = FALSE,
  id = rand_id("umap")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[recipes:selections]{selections()}} for more details.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned? By default, the new columns created by this step from
the original variables will be used as \emph{predictors} in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{outcome}{A call to \code{vars} to specify which variable is used as the
outcome in the encoding process (if any).}

\item{neighbors}{An integer for the number of nearest neighbors used to
construct the target simplicial set. If \code{neighbors} is greater than the
number of data points, the smaller value is used.}

\item{num_comp}{An integer for the number of UMAP components. If \code{num_comp}
is greater than the number of selected columns minus one, the smaller value
is used.}

\item{min_dist}{The effective minimum distance between embedded points.}

\item{metric}{Character, type of distance metric to use to find nearest
neighbors. See \code{\link[uwot:umap]{uwot::umap()}} for more details. Default to \code{"euclidean"}.}

\item{learn_rate}{Positive number of the learning rate for the optimization
process.}

\item{epochs}{Number of iterations for the neighbor optimization. See
\code{\link[uwot:umap]{uwot::umap()}} for more details.}

\item{options}{A list of options to pass to \code{\link[uwot:umap]{uwot::umap()}}. The arguments
\code{X}, \code{n_neighbors}, \code{n_components}, \code{min_dist}, \code{n_epochs}, \code{ret_model},
and \code{learning_rate} should not be passed here. By default, \code{verbose} and
\code{n_threads} are set.}

\item{seed}{Two integers to control the random numbers used by the numerical
methods. The default pulls from the main session's stream of numbers and
will give reproducible results if the seed is set prior to calling \code{\link[=prep]{prep()}}
or \code{\link[=bake]{bake()}}.}

\item{prefix}{A character string for the prefix of the resulting new
variables. See notes below.}

\item{keep_original_cols}{A logical to keep the original variables in the
output. Defaults to \code{FALSE}.}

\item{retain}{Use \code{keep_original_cols} instead to specify whether the
original predictors should be retained along with the new embedding
variables.}

\item{object}{An object that defines the encoding. This is \code{NULL} until the
step is trained by \code{\link[recipes:prep]{recipes::prep()}}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{bake()}}? While all operations are baked
when \code{\link[recipes:prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_umap()} creates a \emph{specification} of a recipe step that will project a
set of features into a smaller space.
}
\details{
UMAP, short for Uniform Manifold Approximation and Projection, is a nonlinear
dimension reduction technique that finds local, low-dimensional
representations of the data. It can be run unsupervised or supervised with
different types of outcome data (e.g. numeric, factor, etc).

The argument \code{num_comp} controls the number of components that will be retained
(the original variables that are used to derive the components are removed from
the data). The new components will have names that begin with \code{prefix} and a
sequence of numbers. The variable names are padded with zeros. For example, if
\code{num_comp < 10}, their names will be \code{UMAP1} - \code{UMAP9}. If \code{num_comp = 101},
the names would be \code{UMAP1} - \code{UMAP101}.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble with columns \code{terms}
(the selectors or variables selected) is returned.
}

\section{Tuning Parameters}{
This step has 5 tuning parameters:
\itemize{
\item \code{num_comp}: # Components (type: integer, default: 2)
\item \code{neighbors}: # Nearest Neighbors (type: integer, default: 15)
\item \code{min_dist}: Min Distance between Points (type: double, default: 0.01)
\item \code{learn_rate}: Learning Rate (type: double, default: 1)
\item \code{epochs}: # Epochs (type: integer, default: NULL)
}
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\section{Saving prepped recipe object}{


This recipe step may require native serialization when saving for
use in another R session. To learn more about serialization for
prepped recipes, see the \href{https://rstudio.github.io/bundle/}{bundle} package.
}

\examples{
\dontshow{if (rlang::is_installed("ggplot2")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(recipes)
library(ggplot2)

split <- seq.int(1, 150, by = 9)
tr <- iris[-split, ]
te <- iris[split, ]

set.seed(11)
supervised <-
  recipe(Species ~ ., data = tr) \%>\%
  step_center(all_predictors()) \%>\%
  step_scale(all_predictors()) \%>\%
  step_umap(all_predictors(), outcome = vars(Species), num_comp = 2) \%>\%
  prep(training = tr)

theme_set(theme_bw())

bake(supervised, new_data = te, Species, starts_with("umap")) \%>\%
  ggplot(aes(x = UMAP1, y = UMAP2, col = Species)) +
  geom_point(alpha = .5)
\dontshow{\}) # examplesIf}
}
\references{
McInnes, L., & Healy, J. (2018). UMAP: Uniform Manifold
Approximation and Projection for Dimension Reduction.
\url{https://arxiv.org/abs/1802.03426}.

"How UMAP Works"
\url{https://umap-learn.readthedocs.io/en/latest/how_umap_works.html}
}
