% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_sparse.R
\name{step_pca_sparse}
\alias{step_pca_sparse}
\title{Sparse PCA Signal Extraction}
\usage{
step_pca_sparse(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  num_comp = 5,
  predictor_prop = 1,
  options = list(),
  res = NULL,
  prefix = "PC",
  keep_original_cols = FALSE,
  skip = FALSE,
  id = rand_id("pca_sparse")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of
operations for this recipe.}

\item{...}{One or more selector functions to choose which variables will be
used to compute the components. See \code{\link[=selections]{selections()}} for more details. For
the \code{tidy} method, these are not currently used.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned? By default, the function assumes that the new principal
component columns created by the original variables will be used as
predictors in a model.}

\item{trained}{A logical to indicate if the quantities for preprocessing have
been estimated.}

\item{num_comp}{The number of components to retain as new predictors.
If \code{num_comp} is greater than the number of columns or the number of
possible components, a smaller value will be used. If \code{num_comp = 0}
is set then no transformation is done and selected variables will
stay unchanged, regardless of the value of \code{keep_original_cols}.}

\item{predictor_prop}{The maximum number of original predictors that can have
non-zero coefficients for each PCA component (via regularization).}

\item{options}{A list of options to the default method for \code{\link[irlba:ssvd]{irlba::ssvd()}}.}

\item{res}{The rotation matrix once this preprocessing step has be trained by
\code{\link[=prep]{prep()}}.}

\item{prefix}{A character string that will be the prefix to the resulting new
variables. See notes below.}

\item{keep_original_cols}{A logical to keep the original variables in the
output. Defaults to \code{FALSE}.}

\item{skip}{A logical. Should the step be skipped when the recipe is baked by
\code{\link[recipes:bake]{recipes::bake()}}? While all operations are baked when \code{\link[recipes:prep]{recipes::prep()}} is
run, some operations may not be able to be conducted on new data (e.g.
processing the outcome variable(s)). Care should be taken when using \code{skip = TRUE} as it may affect the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of existing steps (if any). For the \code{tidy} method, a tibble with
columns \code{terms} (the selectors or variables selected), \code{value} (the
loading), and \code{component}.
}
\description{
\code{step_pca_sparse()} creates a \emph{specification} of a recipe step that will
convert numeric data into one or more principal components that can have some
zero coefficients.
}
\details{
The \code{irlba} package is required for this step. If it is not installed, the
user will be prompted to do so when the step is defined. The \code{\link[irlba:ssvd]{irlba::ssvd()}}
function is used to encourage sparsity; that documentation has details about
this method.

The argument \code{num_comp} controls the number of components that will be retained
(the original variables that are used to derive the components are removed from
the data). The new components will have names that begin with \code{prefix} and a
sequence of numbers. The variable names are padded with zeros. For example, if
\code{num_comp < 10}, their names will be \code{PC1} - \code{PC9}. If \code{num_comp = 101},
the names would be \code{PC1} - \code{PC101}.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble with columns \code{terms}
(the selectors or variables selected), \code{value} and \code{component} is returned.
}

\section{Tuning Parameters}{
This step has 2 tuning parameters:
\itemize{
\item \code{num_comp}: # Components (type: integer, default: 5)
\item \code{predictor_prop}: Proportion of Predictors (type: double, default: 1)
}
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
\dontshow{if (rlang::is_installed(c("modeldata", "ggplot2"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(recipes)
library(ggplot2)

data(ad_data, package = "modeldata")

ad_rec <-
  recipe(Class ~ ., data = ad_data) \%>\%
  step_zv(all_predictors()) \%>\%
  step_YeoJohnson(all_numeric_predictors()) \%>\%
  step_normalize(all_numeric_predictors()) \%>\%
  step_pca_sparse(
    all_numeric_predictors(),
    predictor_prop = 0.75,
    num_comp = 3,
    id = "sparse pca"
  ) \%>\%
  prep()

tidy(ad_rec, id = "sparse pca") \%>\%
  mutate(value = ifelse(value == 0, NA, value)) \%>\%
  ggplot(aes(x = component, y = terms, fill = value)) +
  geom_tile() +
  scale_fill_gradient2() +
  theme(axis.text.y = element_blank())
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=step_pca_sparse_bayes]{step_pca_sparse_bayes()}}
}
\concept{pca}
\concept{preprocessing}
\concept{projection_methods}
\keyword{datagen}
