% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse_stringdist.R
\name{step_collapse_stringdist}
\alias{step_collapse_stringdist}
\title{collapse factor levels using stringdist}
\usage{
step_collapse_stringdist(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  distance = NULL,
  results = NULL,
  columns = NULL,
  skip = FALSE,
  id = rand_id("collapse_stringdist")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables are affected by the step. See \code{\link[=selections]{selections()}}
for more details.  For the \code{tidy} method, these are not
currently used.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{distance}{Integer, value to determine which strings should be collapsed
with which. The value is being used inclusive, so \code{2} will collapse levels
that have a string distance between them of 2 or lower.}

\item{results}{A list denoting the way the labels should be collapses is stored
here once this preprocessing step has be trained by \code{\link[=prep]{prep()}}.}

\item{columns}{A character string of variable names that will
be populated (eventually) by the \code{terms} argument.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{bake()}}? While all operations are baked
when \code{\link[recipes:prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step
added to the sequence of existing steps (if any). For the
\code{tidy} method, a tibble with columns \code{terms} (the
columns that will be affected) and \code{base}.
}
\description{
\code{step_collapse_stringdist} creates a \emph{specification} of a recipe step
that will collapse factor levels that have a low stringdist between them.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble with columns \code{"terms"}
(the column being modified), \code{"from"} (the old levels), \code{"to"} (the new
levels), and \code{"id"}.
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
library(recipes)
library(tibble)
data0 <- tibble(
  x1 = c("a", "b", "d", "e", "sfgsfgsd", "hjhgfgjgr"),
  x2 = c("ak", "b", "djj", "e", "hjhgfgjgr", "hjhgfgjgr")
 )

rec <- recipe(~., data = data0) \%>\%
  step_collapse_stringdist(all_predictors(), distance = 1) \%>\%
  prep()

rec \%>\%
  bake(new_data = NULL)

tidy(rec, 1)

rec <- recipe(~., data = data0) \%>\%
  step_collapse_stringdist(all_predictors(), distance = 2) \%>\%
  prep()

rec \%>\%
  bake(new_data = NULL)

tidy(rec, 1)

}
