% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.em.glm.summary.R
\name{plot.em.glm}
\alias{plot.em.glm}
\title{Plot fit-parameters and errors}
\usage{
\method{plot}{em.glm}(x, known_params = NULL, plot_type = lines,
  add = FALSE, ...)
}
\arguments{
\item{x}{An em.glm fit object.}

\item{known_params}{Prior estimates of fit parameters for comparison.}

\item{plot_type}{The plot type to display.  Defaults to lines, alternative include points.}

\item{add}{Boolean flag to decide if the plot should be added to an existing displayed plot object or create a new axes.}

\item{...}{Arguments to be passed to methods}
}
\description{
Plot fit-parameters and errors
}
\examples{
x <- model.matrix(~ factor(wool) + factor(tension), warpbreaks)
y <- warpbreaks$breaks

m <- em.glm(x = x, y = y, K = 2, b.init = "random")

plot(m)

}
