% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elo.winpct.R
\name{elo.winpct}
\alias{elo.winpct}
\title{Compute a (usually logistic) regression based on win percentage for a series of matches.}
\usage{
elo.winpct(
  formula,
  data,
  family = "binomial",
  weights,
  na.action,
  subset,
  ...,
  running = FALSE,
  skip = 0
)
}
\arguments{
\item{formula}{A formula. See \link[=formula.specials]{the help page for formulas} for details.}

\item{data}{A \code{data.frame} in which to look for objects in \code{formula}.}

\item{family}{Arguments passed to \code{\link[stats]{glm}}.}

\item{weights}{A vector of weights. Note that these are used in calculating wins and losses but
not in the regression.}

\item{na.action}{A function which indicates what should happen when the data contain NAs.}

\item{subset}{An optional vector specifying a subset of observations.}

\item{...}{Arguments passed to \code{\link[stats]{glm}}.}

\item{running}{Logical, denoting whether to calculate "running" projected probabilities. If true, a model is fit for
group 1 on its own to predict group 2, then groups 1 and 2 to predict 3, then groups 1 through 3 to predict 4, etc.
Groups are determined in \code{formula}. Omitting a group term re-runs a glm model to predict each
observation (a potentially time-consuming operation!)}

\item{skip}{Integer, denoting how many groups to skip before fitting the running models. This is helpful if
groups are small, where glm would have trouble converging for the first few groups. The predicted values are then
set to 0.5 for the skipped groups.}
}
\description{
Compute a (usually logistic) regression based on win percentage for a series of matches.
}
\details{
Win percentages are first calculated. Anything passed to \code{\link{adjust}()} in
  \code{formula} is also put in the data.frame. A \code{\link{glm}} model is then
  run to predict wins or margin of victory.

  With this setup, the intercept represents the home-field advantage. Neutral fields can be indicated
  using the \code{\link{neutral}()} function, which sets the intercept to 0.
}
\examples{
elo.winpct(score(points.Home, points.Visitor) ~ team.Home + team.Visitor, data = tournament,
  subset = points.Home != points.Visitor)

elo.winpct(mov(points.Home, points.Visitor) ~ team.Home + team.Visitor, data = tournament,
  family = "gaussian")
}
\seealso{
\code{\link[stats]{glm}}, \code{\link{summary.elo.winpct}}, \code{\link{score}},
  \code{\link{mov}}, \code{\link{elo.model.frame}}
}
