% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.elo.run.R
\name{predict.elo.run}
\alias{predict.elo.run}
\alias{predict.elo.run}
\alias{predict.elo.run.regressed}
\title{Make Predictions on an \code{elo.run} Object}
\usage{
\method{predict}{elo.run}(object, newdata, ...)

\method{predict}{elo.run.regressed}(object, newdata, regressed = FALSE, ...)
}
\arguments{
\item{object}{An object of class \code{"\link{elo.run}"}.}

\item{newdata}{A new dataset containing the same variables as the call
that made \code{object}. If missing, the predicted win probabilities from
\code{object} will be returned.}

\item{...}{Other arguments to be passed to \code{\link{elo.prob}}.}

\item{regressed}{See the note on \code{\link{final.elos}}.}
}
\value{
A vector of win probabilities.
}
\description{
Make Predictions on an \code{elo.run} Object
}
\examples{
data(tournament)
t1 <- head(tournament, -3)
t2 <- tail(tournament, 3)
results <- elo.run(score(points.Home, points.Visitor) ~ team.Home + team.Visitor,
                   data = t1, k = 20)
predict(results)
predict(results, newdata = t2)
}
