% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_elev_raster.R
\name{get_opentopo}
\alias{get_opentopo}
\title{Get a digital elevation model from the Open Topography SRTM Version 3}
\source{
Attribution: Details here
}
\usage{
get_opentopo(locations, src, prj, expand = NULL, ...)
}
\arguments{
\item{locations}{Either a \code{data.frame} of x (long) and y (lat), an 
\code{sp}, an \code{sf}, or \code{raster} object as input.}

\item{prj}{A string defining the projection of the locations argument. The 
string needs to be an acceptable SRS_string for 
\code{\link[sp]{CRS-class}} for your version of PROJ. If a \code{sf} 
object, a \code{sp} object or a \code{raster} object 
is provided, the string will be taken from that.  This 
argument is required for a \code{data.frame} of locations.}

\item{expand}{A numeric value of a distance, in map units, used to expand the
bounding box that is used to fetch the SRTM data.}

\item{...}{Extra configuration parameters to be passed to httr::GET.  Common 
usage is to adjust timeout.  This is done as 
\code{config=timeout(x)} where \code{x} is a numeric value in 
seconds.  Multiple configuration functions may be passed as a 
vector.}
}
\description{
This function uses the Open Topography SRTM Version 3 files.
}
\keyword{internal}
