% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs_get.r
\name{docs_get}
\alias{docs_get}
\title{Get documents}
\usage{
docs_get(
  conn,
  index,
  id,
  type = NULL,
  source = NULL,
  fields = NULL,
  source_includes = NULL,
  source_excludes = NULL,
  exists = FALSE,
  raw = FALSE,
  callopts = list(),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{conn}{an Elasticsearch connection object, see \code{\link[=connect]{connect()}}}

\item{index}{(character) The name of the index. Required}

\item{id}{(numeric/character) The document ID. Can be numeric or character.
Required}

\item{type}{(character) The type of the document. optional}

\item{source}{(logical) If \code{TRUE} (default), return source. note that
it is actually set to \code{NULL} in the function definition, but within
Elasticsearch, it returns the source by default. alternatively,
you can pass a vector of field names to return.}

\item{fields}{Fields to return from the response object.}

\item{source_includes, source_excludes}{(character) fields to include in the
returned document, or to exclude. a character vector}

\item{exists}{(logical) Only return a logical as to whether the document
exists or not.}

\item{raw}{If \code{TRUE} (default), data is parsed to list. If \code{FALSE}, then raw
JSON.}

\item{callopts}{Curl args passed on to \link[crul:HttpClient]{crul::HttpClient}}

\item{verbose}{If TRUE (default) the url call used printed to console.}

\item{...}{Further args passed on to elastic search HTTP API as parameters.}
}
\description{
Get documents
}
\examples{
\dontrun{
(x <- connect())

if (!index_exists(x, "shakespeare")) {
  shakespeare <- system.file("examples", "shakespeare_data_.json",
    package = "elastic")
  shakespeare <- type_remover(shakespeare)
  invisible(docs_bulk(x, shakespeare))
}

docs_get(x, index='shakespeare', id=10)
docs_get(x, index='shakespeare', id=12)
docs_get(x, index='shakespeare', id=12, source=TRUE)

# Get certain fields
if (gsub("\\\\.", "", x$ping()$version$number) < 500) {
  ### ES < v5
  docs_get(x, index='shakespeare', id=10, fields='play_name')
  docs_get(x, index='shakespeare', id=10, fields=c('play_name','speaker'))
} else {
  ### ES > v5
  docs_get(x, index='shakespeare', id=10, source='play_name')
  docs_get(x, index='shakespeare', id=10, source=c('play_name','speaker'))
}

# Just test for existence of the document
docs_get(x, index='plos', id=1, exists=TRUE)
docs_get(x, index='plos', id=123456, exists=TRUE)

# source includes / excludes
docs_get(x, index='shakespeare', id=10, source_includes = "play_name")
docs_get(x, index='shakespeare', id=10, source_excludes = "play_name")
}
}
\references{
\url{https://www.elastic.co/guide/en/elasticsearch/reference/current/docs-get.html}
}
