% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md_bayes_draw.R
\name{md_bayes_draw}
\alias{md_bayes_draw}
\title{MD Bayes Draw}
\usage{
md_bayes_draw(
  dat,
  race_vote_split,
  form,
  ntunes = 10,
  totaldraws = 1e+05,
  seed = 12345,
  sample = 1e+05,
  thin = 100,
  burnin = 1e+05,
  ret.mcmc = TRUE
)
}
\arguments{
\item{dat}{data.frame() object of just raw candidate vote and raw population
counts. Put vote results in first set of columns, put population counts next}

\item{race_vote_split}{Numeric vector of length 2 indicating where vote
column ends (e.g., 3), and population counts begin (e.g., 4): c(3,4)}

\item{form}{Formula object, e.g.: cbind(V1, V2, novote) ~ cbind(VtdAVap_cor,
VtdBVap_cor, VtdHVap_cor, VtdOVap_cor)}

\item{ntunes}{Numeric; how much to tune tuneMD. Default = 10}

\item{totaldraws}{Numeric; How many total draws from MD. Default = 100000}

\item{seed}{Numeric. Default = 12345}

\item{sample}{Numeric. Default = 100000}

\item{thin}{Numeric. Default = 10}

\item{burnin}{Numeric. Default = 100000}

\item{ret.mcmc}{Logical. Default = TRUE}
}
\value{
Matrix object, of simulation reults
}
\description{
Tunes and estimates MD Bayes algorithm (ei.MD.bayes)
}
\examples{

\dontrun{
# TOY DATA EXAMPLE
canda <- c(10, 8, 10, 4, 8)
candb <- 20 - canda
white <- c(15, 12, 18, 6, 10)
black <- 20 - white
toy <- data.frame(canda, candb, white, black)

# Generate formula for passage to ei.reg.bayes() function
form <- formula(cbind(canda, candb) ~ cbind(black, white))
# Then excute md_bayes_draw(); not run here due to time
# md_bayes_draw(toy, c(2,3), form )
}
}
\references{
eiPack, King et. al. (http://gking.harvard.edu/eiR)
}
\author{
Loren Collingwood <loren.collingwood@ucr.edu>
}
