% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composition.R
\name{comp_ply}
\alias{comp_ply}
\title{Calculate third-party compositional measures on an \code{egor} object}
\usage{
comp_ply(object, alt.attr, .f, ..., ego.attr = NULL)
}
\arguments{
\item{object}{An \code{egor} object.}

\item{alt.attr}{A \code{character} naming the variable containing the alter-attribute.}

\item{.f}{A \code{function} that returns a numeric.}

\item{...}{Optional arguments to \code{.f}.}

\item{ego.attr}{Optional  \code{character} naming an ego attribute.}
}
\value{
A \code{numeric} vector.
}
\description{
\code{comp_ply()} applies a function, that uses an alter attribute to calculate
a compositional measurement, on all networks in an \code{egor} object and returns a
\verb{numeric vector}.
}
\details{
When an ego attribute is used the \code{.f} is called like this:
\code{.f(alt.attr, ego.attr, ...)}. \code{.f} must return a single numeric value.
}
\examples{
df <- make_egor(10, 32)
comp_ply(df, "age.years", sd, na.rm = TRUE)
}
\author{
Michał Bojanowski, \email{m.bojanowski@uw.edu.pl}

Till Krenz, \email{public@tillt.net}
}
\keyword{analysis}
\keyword{ego-centered}
\keyword{network}
