\docType{data}
\name{tab1morgan}
\alias{tab1morgan}
\title{Abundance of trichostrongyloid eggs in sheep faeces}
\format{A data frame with 14 rows and 13 variables}
\source{
Morgan ER, Cavill L, Curry GE, Wood RM, Mitchell ESE (2005).
 Effects of aggregation and sample size on composite faecal egg counts in sheep,
 Veterinary Parasitology, 121:79-87.
}
\usage{
data(tab1morgan)
}
\description{
This data set contains information about the abundance and distribution of
trichostrongyloid eggs in the faeces of 14 groups of commercially farmed
sheep given in Table 1 in Morgan et al. (2005).
The faecal egg counts were assumed to follow a negative binomial distribution
with mean \eqn{m} and overdispersion parameter \eqn{k}.
}
\details{
The data set has columns:

\tabular{ll}{
  group \tab ID number for the groups \cr
  ageclass \tab age class of sheep: "Lambs" or "Ewes" \cr
  month \tab month when samples were taken \cr
  n \tab number of sheep in group \cr
  meanFEC \tab mean number of eggs per gram (epg) of  faeces \cr
  k \tab estimated overdispersion parameter \eqn{k} \cr
  k.low \tab lower limit of a 95\% confidence interval for \eqn{k} \cr
  k.up \tab lower limit of a 95\% confidence interval for \eqn{k} \cr
  maxFEC \tab maximal number of eggs per gram of faeces per group \cr
  percentageLarger1000 \tab percentage of samples with more than 1000 epg \cr
  Chi2 \tab goodness-of-fit statistic for the negative binomial distribution \cr
  df \tab corresponding degrees of freedom \cr
  p \tab corresponding p-value
}
}
\examples{
data(tab1morgan)
if (require("lattice"))
   xyplot(k.low+k.up+k ~meanFEC, type="p", pch=19, col=c(8,8,1), data=tab1morgan)
}
\keyword{datasets}

