% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtable_frame.r
\name{gtable_frame}
\alias{gtable_frame}
\title{gtable_frame}
\usage{
gtable_frame(g, width = unit(1, "null"), height = unit(1, "null"),
  debug = FALSE)
}
\arguments{
\item{g}{gtable}

\item{width}{requested width}

\item{height}{requested height}

\item{debug}{logical draw gtable cells}
}
\value{
3x3 gtable wrapping the plot
}
\description{
Reformat the gtable associated with a ggplot object into a 3x3 gtable where the central cell corresponds to the plot panel(s).
}
\examples{
library(grid)
library(gridExtra)
p1 <- ggplot(mtcars, aes(mpg, wt, colour = factor(cyl))) +
  geom_point()

p2 <- ggplot(mtcars, aes(mpg, wt, colour = factor(cyl))) +
  geom_point() + facet_wrap( ~ cyl, ncol=2, scales = "free") +
  guides(colour="none") +
  theme()

p3 <- ggplot(mtcars, aes(mpg, wt, colour = factor(cyl))) +
  geom_point() + facet_grid(. ~ cyl, scales = "free")

g1 <- ggplotGrob(p1);
g2 <- ggplotGrob(p2);
g3 <- ggplotGrob(p3);
fg1 <- gtable_frame(g1)
fg2 <- gtable_frame(g2)
fg12 <- gtable_frame(gtable_rbind(fg1,fg2), width=unit(2,"null"), height=unit(1,"null"))
fg3 <- gtable_frame(g3, width=unit(1,"null"), height=unit(1,"null"))
grid.newpage()
combined <- gtable_cbind(fg12, fg3)
grid.draw(combined)
}
