% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize}
\alias{normalize}
\alias{normalize.numeric}
\alias{normalize.grouped_df}
\alias{normalize.data.frame}
\title{Normalize numeric variable to [0-1] range}
\usage{
normalize(x, ...)

\method{normalize}{numeric}(x, include_bounds = TRUE, verbose = TRUE, ...)

\method{normalize}{grouped_df}(
  x,
  select = NULL,
  exclude = NULL,
  include_bounds = TRUE,
  verbose = TRUE,
  ...
)

\method{normalize}{data.frame}(
  x,
  select = NULL,
  exclude = NULL,
  include_bounds = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{A numeric vector, data frame, or matrix. See details.}

\item{...}{Arguments passed to or from other methods.}

\item{include_bounds}{Logical, if \code{TRUE}, return value may include 0 and 1.
If \code{FALSE}, the return value is compressed, using Smithson and Verkuilen's
(2006) formula \code{(x * (n - 1) + 0.5) / n}, to avoid zeros and ones in the
normalized variables. This can be useful in case of beta-regression, where
the response variable is not allowed to include zeros and ones.}

\item{verbose}{Toggle warnings and messages on or off.}

\item{select}{Character vector of column names. If \code{NULL} (the default), all
variables will be selected.}

\item{exclude}{Character vector of column names to be excluded from selection.}
}
\value{
A normalized object.
}
\description{
Performs a normalization of data, i.e., it scales variables in the range 0 -
\enumerate{
\item This is a special case of \code{\link[=change_scale]{change_scale()}}.
}
}
\details{
\itemize{
\item If \code{x} is a matrix, normalization is performed across all values (not
column- or row-wise). For column-wise normalization, convert the matrix to a
data.frame.
\item If \code{x} is a grouped data frame (\code{grouped_df}), normalization is performed
separately for each group.
}
}
\examples{
normalize(c(0, 1, 5, -5, -2))
normalize(c(0, 1, 5, -5, -2), include_bounds = FALSE)

head(normalize(trees))
}
\references{
\itemize{
\item Smithson M, Verkuilen J (2006). A Better Lemon Squeezer? Maximum-Likelihood
Regression with Beta-Distributed Dependent Variables. Psychological Methods,
11(1), 54–71.
}
}
\seealso{
Other transform utilities: 
\code{\link{change_scale}()},
\code{\link{ranktransform}()},
\code{\link{standardize}()}
}
\concept{transform utilities}
