% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpret_rope.R
\name{interpret_rope}
\alias{interpret_rope}
\title{Interpret Bayesian diagnostic indices}
\usage{
interpret_rope(rope, ci = 0.9, rules = "default")
}
\arguments{
\item{rope}{Value or vector of percentages in ROPE.}

\item{ci}{The Credible Interval (CI) probability, corresponding to the proportion of HDI, that was used. Can be \code{1} in the case of "full ROPE".}

\item{rules}{A character string (see details) or a custom set of \code{\link[=rules]{rules()}}.}
}
\description{
Interpretation of Bayesian indices of percentage in ROPE.
}
\details{
Rules sets:
\itemize{
\item \strong{ROPE}: Can be \href{https://easystats.github.io/bayestestR/articles/guidelines.html}{"default"}.
}
}
\examples{
#'
interpret_rope(0, ci = 0.9)
interpret_rope(c(0.005, 0.99), ci = 1)

}
\references{
\href{https://easystats.github.io/bayestestR/articles/guidelines.html}{BayestestR's reporting guidelines}
}
