% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regex.search.R
\name{regex.search}
\alias{regex.search}
\title{Searching for motifs using regular expressions (REGEX)}
\usage{
regex.search(sequence, motif = "RxLR", reg.pat = NULL)
}
\arguments{
\item{sequence}{A list of \code{SeqFastadna} objects from \code{seqinr} \code{\link{read.fasta}}. The \code{SeqFastadna} object must be comprised by amino acid sequences, not DNA sequences}

\item{motif}{A character string indicating the motif to be searched. Motifs for two cytoplasmic effectors are added to the function: \code{RxLR} or \code{CRN} effectors. Each of these motifs are associated with a by-default REGEX (\code{reg.pat}).These motifs are adapted from Haas et al. (2009).

A third option, \code{custom}, allows for the search of custom motifs. The \code{custom} option requires the specification of the motif REGEX pattern in the \code{reg.pat} option, in a \code{\link{regex}} format.

Default \code{motif} is RxLR}

\item{reg.pat}{A character string indicating the REGEX pattern for the \code{custom} motif. The specification of the REGEX pattern in must be in \code{\link{regex}} format. Required for \code{custom} option of \code{motif}}
}
\description{
This function uses searches a list of \code{SeqFastadna} objects for sequences with RxLR or CRN motifs.
}
\examples{
fasta.file <- system.file("extdata", "test_infestans.fasta", package = "effectR")
ORF <- seqinr::read.fasta(fasta.file)
rxlr.cand <- regex.search(ORF)
custom.cand <- regex.search(ORF, motif = "custom", reg.pat ="^\\\\w{12,60}r\\\\wlr\\\\w{6,10}eer")

}
\references{
Haas, B.J., Kamoun, S., Zody, M.C., Jiang, R.H., Handsaker, R.E., Cano, L.M., Grabherr, M.,
 Kodira, C.D., Raffaele, S., Torto-Alalibo, T. and Bozkurt, T.O., 2009.
 Genome sequence and analysis of the Irish potato famine pathogen Phytophthora infestans.
 Nature, 461(7262), p.393.
}
\keyword{effector}
\keyword{regex}
