% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_dpi.R
\name{theme_dpi_map2}
\alias{theme_dpi_map2}
\title{an alternate ggplot2 theme developed for PDF or SVG maps}
\source{
For more information see https://github.com/hadley/ggplot2/wiki/Themes
}
\usage{
theme_dpi_map2(base_size = 14, base_family = "")
}
\arguments{
\item{base_size}{numeric, specify the font size, default is 14}

\item{base_family}{character, specify the font family, this value is optional}
}
\value{
A theme object which is a list of attributes applied to a ggplot2 object.
}
\description{
This is a custom ggplot2 theme developed for the Wisconsin 
Department of Public Instruction for making PDF maps
}
\details{
All values are optional
}
\examples{
# Data
crimes <- data.frame(state = tolower(rownames(USArrests)), USArrests)
require(reshape) # for melt
crimesm <- melt(crimes, id = 1)
# No DPI theme
states_map <- map_data("state")
ggplot(crimes, aes(map_id = state)) + geom_map(aes(fill = Murder), map = states_map) + 
    expand_limits(x = states_map$long, y = states_map$lat)+ labs(title="USA Crime")
# Draw map
last_plot() + coord_map()
# DPI theme
ggplot(crimesm, aes(map_id = state)) + geom_map(aes(fill = value), map = states_map) + 
    expand_limits(x = states_map$long, y = states_map$lat) + 
    facet_wrap( ~ variable) + theme_dpi_map2()
}
\author{
Jared E. Knowles
}
\seealso{
his uses \code{\link{unit}} from the grid package extensively. 
See also \code{\link{theme_bw}} from the ggplot2 package.
}

