% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cueWindow.R
\name{cueWindow}
\alias{cueWindow}
\title{Create a 'cue window', for overlapping or continuous cues.}
\usage{
cueWindow(
  x,
  n = 1,
  step = 1,
  weights = NULL,
  min = 1,
  max = 100,
  round.values = TRUE,
  split = "_",
  premark = "",
  postmark = "",
  as.numeric = FALSE,
  dec = NULL
)
}
\arguments{
\item{x}{A vector with numeric cues.}

\item{n}{Numeric value specifying the window size. If \code{n} has two 
values, the first value indicates the left window size, and the second 
value the size of the right window.}

\item{step}{Numeric value, indicating the difference between adjacent 
cues values. Set to 1 by default.}

\item{weights}{A vector with weights (round numbers) for multiplying the
elements within the window. Defaults to NULL (which will give all cues 
the same weight).}

\item{min}{Numeric value specifying the lowest value on the scale. 
Defaults to 1.}

\item{max}{Numeric value specifying the maximum value on the scale. 
Defaults to 100.}

\item{round.values}{Logical, whether or not to round the values of 
\code{x} to multiples of \code{step} on the continuum between \code{min} 
and \code{max}. Defaults to TRUE.}

\item{split}{String, specifying the cue separator. Default value is "_".}

\item{premark}{String, specifying a character to add before each cue.}

\item{postmark}{String, specifying a character to add after each cue.}

\item{as.numeric}{Logical, whether or not to return the numeric values 
of the window as a list. Default is FALSE (return cue sets as a vector of 
strings).}

\item{dec}{Number of decimals for rounding. Defaults to NULL 
(automatically determined).}
}
\value{
A vector of strings (default), or a list with vectors of numbers.
}
\description{
Create a 'cue window', for overlapping or continuous cues.
}
\examples{
# generate random sample of cues on continuum of 1-10,
# with sep=1:
set.seed(123)
cues <- round(runif(20, min=0.5, max=10.5),1)

# Note that cues will be converted to rounded numbers
# as round.values=TRUE. With cue window of 3:
cueWindow(cues, n=3, max=10)
# step of 0.5 increases number of neighboring cues:
cueWindow(cues, n=3, max=10, step=.5)
# cue window of 5:
cueWindow(cues, n=5, max=10)
# asymmetrical window:
cueWindow(cues, n=c(2,1), max=10, step=.5)

# non-uniform weights:
cueWindow(cues, n=5, max=10, weights=c(1,2,3,2,1)) 
cueWindow(cues, n=2.5, max=10, step=.5, weights=c(1,2,3,2,1)) 
# left cues have stronger weights:
cueWindow(cues, n=5, max=10, weights=c(3,3,2,1,1))
# adjust weights, so that cue itself is not included:
cueWindow(cues, n=c(2,1), max=10, weights=c(1,1,0,1))
# premarking:
cueWindow(cues, n=2, max=10, weights=c(1,1,1), premark="stimulus")
# numeric output:
cueWindow(cues, n=2, max=10, weights=c(1,2,1), as.numeric=TRUE)

}
\author{
Jacolien van Rij
}
