% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RWlearningMatrix.R
\name{RWlearningMatrix}
\alias{RWlearningMatrix}
\title{Function implementing the Rescorla-Wagner learning.}
\usage{
RWlearningMatrix(
  data,
  wm = NULL,
  alpha = 0.1,
  lambda = 1,
  beta1 = 0.1,
  beta2 = 0.1,
  progress = TRUE,
  ...
)
}
\arguments{
\item{data}{A data frame with columns \code{Cues} and \code{Outcomes}.}

\item{wm}{A weightmatrix of class matrix, or a list with weight matrices. 
If not provided a new 
weightmatrix is returned. Note that the cues and outcomes do not 
necessarily need to be available as cues and outcomes in the weightmatrix: 
if not present, they will be added.}

\item{alpha}{Learning parameter (scaling both positive and negative 
evidence adjustments), typically set to 0.1.}

\item{lambda}{Constant constraining the connection strength.}

\item{beta1}{Learning parameter for positive evidence, typically set to 
0.1.}

\item{beta2}{Learning parameter for negative evidence, typically set to 
0.1.}

\item{progress}{Logical: whether or not showing a progress bar 
(may slow down the process).}

\item{...}{Parameters for the function \code{\link{getValues}}.}
}
\value{
A weightmatrix.
}
\description{
Function implementing the Rescorla-Wagner learning.
}
\examples{
# load example data:
data(dat)

# add obligatory columns Cues, Outcomes, and Frequency:
dat$Cues <- paste("BG", dat$Shape, dat$Color, sep="_")
dat$Outcomes <- dat$Category
dat$Frequency <- dat$Frequency1
head(dat)
dim(dat)

# now use createTrainingData to sample from the specified frequencies: 
train <- createTrainingData(dat)

# this training data can actually be used train network:
wm1 <- RWlearningMatrix(train)
# comparison with a list:
wm2 <- RWlearning(train)
length(wm2)
getWM(wm2)

# in R markdown or knitr reports the progress bar should be turned off:
wm <- RWlearningMatrix(train, progress=FALSE)

# Learning in steps is also possible:
wm <- RWlearningMatrix(train[1:20,])

train[21,c("Cues", "Outcomes")]
wm <- RWlearningMatrix(train[21,], wm=wm)

}
\seealso{
\code{\link[ndl]{RescorlaWagner}}, \code{\link{updateWeights}}
}
\author{
Jacolien van Rij
}
