% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flow_tnss.R
\name{tnss_tree}
\alias{tnss_tree}
\title{Create Steiner tree from real and dummy points}
\usage{
tnss_tree(
  g,
  xy,
  xydummy,
  root,
  gamma = 0.9,
  epsilon = 0.3,
  elen = Inf,
  order = "random"
)
}
\arguments{
\item{g}{original flow network (must be a one-to-many flow network, i.e star graph). Must have a weight attribute indicating the flow}

\item{xy}{coordinates of "real" nodes}

\item{xydummy}{coordinates of "dummy" nodes}

\item{root}{root node id of the flow}

\item{gamma}{edge length decay parameter}

\item{epsilon}{smoothing factor for Douglas-Peucker Algorithm}

\item{elen}{maximal length of edges in triangulation}

\item{order}{in which order shortest paths are calculated ("random","weight","near","far")}
}
\value{
approximated Steiner tree from dummy and real nodes as igraph object
}
\description{
creates an approximated Steiner tree for a flow map visualization
}
\details{
Use \link{tnss_smooth} to smooth the edges of the tree
}
\examples{
xy <- cbind(state.center$x,state.center$y)[!state.name\%in\%c("Alaska","Hawaii"),]
xy_dummy <- tnss_dummies(xy,root = 4)
gtree <- tnss_tree(cali2010,xy,xy_dummy,root = 4,gamma = 0.9)
}
\references{
Sun, Shipeng. "An automated spatial flow layout algorithm using triangulation, approximate Steiner tree, and path smoothing." AutoCarto, 2016.
}
\author{
David Schoch
}
