% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mov_med.R
\name{mov_med}
\alias{mov_med}
\title{Moving Median over a Time Window}
\usage{
mov_med(data, med_win = c(-42, 42), min_pts_in_win = 1)
}
\arguments{
\item{data}{A data frame in long format containing the data for which events
is to be detected. This means that each measurement corresponds to a row
and the columns are (in order): source (the device or person from which the
data was collected), point in time, and
measurement value. If custom detection bounds are chosen, the folloing two
columns must be added: lower detection bound, and upper detection bound.

The source is expected to
be a string; the time point are integers; measurements, and detection bounds are expected to be numerical.
The detection bounds are in absolute value in the same unit as the
values and each is expected to be identical for the same source.

In case detection is wanted for a one sided change (e.g. give an event if
the confidence bounds drop below a threshold) then the upper or lower detection
bound can be chosen to be Inf or -Inf respectively.}

\item{med_win}{A vector containing two numbers specifying the window over
which the moving median is to be taken. More specifically, when given a
certain time point, the numbers specify the maximum number of time units
difference that a time point can have such that that data point will be
considered for the moving median. Note that the first number must be smaller
than the second number. The numbers may be negative.}

\item{min_pts_in_win}{The minimal number of measurements required to be in
the time window in order for the median to be calculated.}
}
\value{
A data frame containing the values of the moving median, the study
day to which it corresponds, the time window from which it was calculated,
and the subject id corresponding to the data.
}
\description{
Calculates the moving median over a time window around a time point for the
all time points between the first and last time point provided.
}
\details{
Consider a sample \eqn{X_1,\dots, X_n} of size \eqn{n} and the
reordering \eqn{X_{(1)},\dots, X_{(n)}} such
that \eqn{X_{(1)} \le X_{(2)} \le \dots \le X_{(n)}}, commonly
called the order statistic. Then for \eqn{n} even the median usually
defined as \deqn{median(X_1,\dots, X_n) = X_{(k)}, \mathrm{where } \;  k = n/2.} In the
case where \eqn{n} is odd the median is
defined as \deqn{median(X_1,\dots, X_n) = 1/2(X_{(k)} + X_{(k+1)}), \mathrm{where } \;  k = n/2.} Let the
study days at which the measurements \eqn{X_1, \dots, X_n} were taken
be \eqn{t_1, \dots, t_n}.
Let \eqn{T} a fixed positive amount of time. Then the moving median at time
point \eqn{t} with window size \eqn{T} is defined as
\deqn{S(t) = median({X_j | t - T/2 \le t_j \le t + T/2}).}

For the initial time points where the time difference between the first data
point and the time point for which we are calculating the median is less than
half the \code{width}, we do not have enough data points to form a window
which has the same size to both sides of the time point. In this case fewer
data points are used to calculate the median and the time window is not
symmetric around the time point for which we are calculating the median.

No median is calculated if the time difference between the last data point
and the current time point for which we are calculating the median is less
than half the \code{width}. We do not calculate the median using a smaller
time window so that the values do not change upon receiving new data with
time points newer than that of the old data.
}
