% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_event.R
\name{detect_event}
\alias{detect_event}
\title{Detect Events}
\usage{
detect_event(conf_band, detec_lower, detec_upper, min_change_dur)
}
\arguments{
\item{conf_band}{A data frame containing the confidence bounds. Ideally the output of \code{\link{conf_band}}.}

\item{detec_lower}{The lower detection bound in the same units as the values in data.}

\item{detec_upper}{The upper detection bound in the same units as the values in data.}

\item{min_change_dur}{The minimal number of time units that the confidence bounds
need to stay inside the detection bounds in order for an event to be
detected. Defaults to 84, i.e. 12 weeks.}
}
\value{
A list of four values: \describe{ \item{\code{event_detected}}{gives
whether an event was detected}
\item{\code{event_onset}}{gives the time_point at which the
event was detected} \item{\code{event_duration}}{gives the duration the
event is sustained} \item{\code{event_stop}}{gives whether the detected
event is censored}
}
}
\description{
Detect events using the confidence bounds. An event is detected if all the
points of the upper or lower bound of the confidence band are below or above
the threshold for \code{min_change_dur} consecutive days.
}
