% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_trim_lifecycle.R
\name{filter_trim_lifecycle}
\alias{filter_trim_lifecycle}
\alias{filter_trim_lifecycle.eventlog}
\alias{filter_trim_lifecycle.grouped_eventlog}
\title{Filter Trim Life Cycle}
\usage{
filter_trim_lifecycle(
  log,
  start_lifecycles = NULL,
  end_lifecycles = NULL,
  reverse = FALSE,
  start_lifecycle = deprecated(),
  end_lifecycle = deprecated(),
  eventlog = deprecated()
)

\method{filter_trim_lifecycle}{eventlog}(
  log,
  start_lifecycles = NULL,
  end_lifecycles = NULL,
  reverse = FALSE,
  start_lifecycle = deprecated(),
  end_lifecycle = deprecated(),
  eventlog = deprecated()
)

\method{filter_trim_lifecycle}{grouped_eventlog}(
  log,
  start_lifecycles = NULL,
  end_lifecycles = NULL,
  reverse = FALSE,
  start_lifecycle = deprecated(),
  end_lifecycle = deprecated(),
  eventlog = deprecated()
)
}
\arguments{
\item{log}{\code{\link[bupaR]{eventlog}}: Object of class \code{\link[bupaR]{eventlog}} or derivatives (\code{\link[bupaR]{grouped_eventlog}}).}

\item{start_lifecycles, end_lifecycles}{\code{\link{character}} vector (default \code{\link{NULL}}): A vector of life cycle
identifiers, or \code{\link{NULL}}.}

\item{reverse}{\code{\link{logical}} (default \code{FALSE}): Indicating whether the selection should be reversed.}

\item{start_lifecycle}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}; please use \code{start_lifecycles} instead.}

\item{end_lifecycle}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}; please use \code{end_lifecycles} instead.}

\item{eventlog}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}; please use \code{log} instead.}
}
\value{
When given an object of type \code{\link[bupaR]{log}}, it will return a filtered \code{\link[bupaR]{log}}.
When given an object of type \code{\link[bupaR]{grouped_log}}, the filter will be applied in a stratified way (i.e. each separately for each group).
The returned log will be grouped on the same variables as the original log.
}
\description{
Trim activity instances from the first event of a set of start life cycle labels to the last event of a set of end life cycle labels.

One can trim activity instances by removing one or more events at the start and/or end of the activity instances.
Trimming is performed until all activity instances have a start and/or end point belonging to a set of allowed life cycle labels.
This filter requires a set of allowed start life cycle labels and/or a set of allowed life cycle labels. If one of them
is not provided it will not trim the activity instances at this edge.The selection can be reversed, which means that
only the trimmed events at the start and end of activity instances are retained. As such, this argument allows to cut
intermediate parts out of activity instances.
}
\section{Methods (by class)}{
\itemize{
\item \code{filter_trim_lifecycle(eventlog)}: Filters activity instances for an \code{\link[bupaR]{eventlog}}.

\item \code{filter_trim_lifecycle(grouped_eventlog)}: Filters activity instances for a \code{\link[bupaR]{grouped_eventlog}}.

}}
\references{
Swennen, M. (2018). Using Event Log Knowledge to Support Operational Exellence Techniques (Doctoral dissertation). Hasselt University.
}
\seealso{
\code{\link[bupaR]{lifecycle_id}}

Other filters: 
\code{\link{filter_activity_frequency}()},
\code{\link{filter_activity_instance}()},
\code{\link{filter_activity_presence}()},
\code{\link{filter_activity}()},
\code{\link{filter_case_condition}()},
\code{\link{filter_case}()},
\code{\link{filter_endpoints_condition}()},
\code{\link{filter_endpoints}()},
\code{\link{filter_flow_time}()},
\code{\link{filter_idle_time}()},
\code{\link{filter_infrequent_flows}()},
\code{\link{filter_lifecycle_presence}()},
\code{\link{filter_lifecycle}()},
\code{\link{filter_precedence_condition}()},
\code{\link{filter_precedence_resource}()},
\code{\link{filter_precedence}()},
\code{\link{filter_processing_time}()},
\code{\link{filter_resource_frequency}()},
\code{\link{filter_resource}()},
\code{\link{filter_throughput_time}()},
\code{\link{filter_time_period}()},
\code{\link{filter_trace_frequency}()},
\code{\link{filter_trace_length}()},
\code{\link{filter_trace}()},
\code{\link{filter_trim}()}
}
\concept{filters}
\concept{filters_event}
