% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_resource.R
\name{filter_resource}
\alias{filter_resource}
\alias{filter_resource.log}
\alias{filter_resource.grouped_log}
\title{Filter Resource}
\usage{
filter_resource(log, resources, reverse = FALSE, eventlog = deprecated())

\method{filter_resource}{log}(log, resources, reverse = FALSE, eventlog = deprecated())

\method{filter_resource}{grouped_log}(log, resources, reverse = FALSE, eventlog = deprecated())
}
\arguments{
\item{log}{\code{\link[bupaR]{log}}: Object of class \code{\link[bupaR]{log}} or derivatives (\code{\link[bupaR]{grouped_log}}, \code{\link[bupaR]{eventlog}}, \code{\link[bupaR]{activitylog}}, etc.).}

\item{resources}{\code{\link{character}} vector: A vector of resources identifiers.}

\item{reverse}{\code{\link{logical}} (default \code{FALSE}): Indicating whether the selection should be reversed.}

\item{eventlog}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}; please use \code{log} instead.}
}
\value{
When given an object of type \code{\link[bupaR]{log}}, it will return a filtered \code{\link[bupaR]{log}}.
When given an object of type \code{\link[bupaR]{grouped_log}}, the filter will be applied in a stratified way (i.e. each separately for each group).
The returned log will be grouped on the same variables as the original log.
}
\description{
Filters the log based on resource identifiers

This method can be used to filter on resource identifiers. It has a \code{resources} argument,
to which a vector of identifiers can be given. The selection can be negated with the \code{reverse} argument.
}
\section{Methods (by class)}{
\itemize{
\item \code{filter_resource(log)}: Filters resources for a \code{\link[bupaR]{log}}.

\item \code{filter_resource(grouped_log)}: Filters resources for a \code{\link[bupaR]{grouped_log}}.

}}
\references{
Swennen, M. (2018). Using Event Log Knowledge to Support Operational Exellence Techniques (Doctoral dissertation). Hasselt University.
}
\seealso{
Other filters: 
\code{\link{filter_activity_frequency}()},
\code{\link{filter_activity_instance}()},
\code{\link{filter_activity_presence}()},
\code{\link{filter_activity}()},
\code{\link{filter_case_condition}()},
\code{\link{filter_case}()},
\code{\link{filter_endpoints_condition}()},
\code{\link{filter_endpoints}()},
\code{\link{filter_infrequent_flows}()},
\code{\link{filter_lifecycle_presence}()},
\code{\link{filter_lifecycle}()},
\code{\link{filter_precedence_condition}()},
\code{\link{filter_precedence_resource}()},
\code{\link{filter_precedence}()},
\code{\link{filter_processing_time}()},
\code{\link{filter_resource_frequency}()},
\code{\link{filter_throughput_time}()},
\code{\link{filter_time_period}()},
\code{\link{filter_trace_frequency}()},
\code{\link{filter_trace_length}()},
\code{\link{filter_trace}()},
\code{\link{filter_trim_lifecycle}()},
\code{\link{filter_trim}()}
}
\concept{filters}
\concept{filters_event}
