% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_preferences.R
\name{plot_preferences}
\alias{plot_preferences}
\title{Plot the resource preferences of a consumer}
\usage{
plot_preferences(
  nullnet,
  node,
  signif.level = 0.95,
  style = "dots",
  type = "counts",
  res.col = c("#67A9CF", "#F7F7F7", "#EF8A62"),
  res.order = NULL,
  l.cex = 1,
  p.cex = 1,
  ...
)
}
\arguments{
\item{nullnet}{An object of class nullnet from \code{generate_null_net}}

\item{node}{A string specifying the consumer node (species) whose
preferences will be plotted}

\item{signif.level}{An optional value specifying the threshold used for
testing for 'significant' deviations from the null model.  Defaults to 0.95}

\item{style}{An optional string to set whether a dotchart or bar chart is
plotted. The default (\code{style = "dots"}) is a Cleveland dot plot,
whilst the alternative (\code{style = "bars"}) is a bar chart of the type
used by King \emph{et al.} (2010) and Davey \emph{et al.} (2013).}

\item{type}{Optional string to specify how preferences are displayed. The
default (\code{type = "counts"}) is the total number of interactions or
mean interaction strength, depending upon which one was requested in the
original call to \code{\link{generate_null_net}} using the
\code{summary.type} argument.  The alternative is the standardised effect
size (\code{type = "SES"}).  With \code{type = "counts"},
confidence limits will be drawn, whilst for the standardised effect
size, dashed lines are added at +2 and -2, which is approximately equivalent
to a 5\% significance level: fill colours for \code{type = "SES"} are
based on the estimated confidence limits, rather than the +2/-2 thresholds.}

\item{res.col}{An optional character vector of length three specifying
the colours with which to fill the dots or bars representing interactions
that are weaker than expected, consistent with the null model and stronger
than expected (in that order). The default is a red-blue colour scheme.}

\item{res.order}{An optional data frame used to set the order in which the
resource species are plotted.  Should have two columns: the first listing
the resource species (names must be identical to those used by
\code{generate_null_net}) and the second the plotting order (bars will be
plotted in ascending order)}

\item{l.cex}{An optional numeric value to set the size of the labels when
using \code{style = "dots"}. Ignored when \code{style = "bars"}, as
\code{barplot}'s \code{cex.names} argument can be used.}

\item{p.cex}{An optional numeric value to set the size of the points when
when using \code{style = "dots"}.}

\item{...}{Other arguments to control basic plotting functions in R, such as
\code{lwd}, \code{xlab}, \code{ylab}, \code{main}, \code{xlim} and
\code{ylim}.}
}
\description{
Takes a 'nullnet' object from running a null model with
  \code{generate_null_net} and plots the observed and expected link
  strengths for every resource for a selected consumer species (node in
  the network).  There are two styles of plot: the default is a dot plot
  based on \code{\link[graphics]{dotchart}}, whilst the alternative is a
  bar plot based on \code{\link[graphics]{barplot}}.  There are arguments in
  \code{plot_preferences} to set some of the graphical parameters, but see
  the respective help files for \code{\link[graphics]{dotchart}} and
  \code{\link[graphics]{barplot}} for further options to customise the plots.
}
\details{
Plots the preferences for individual consumer species. The bar plot
  format follows the basic style of King \emph{et al}. (2010; Figure 3) and
  Davey \emph{et al.} (2013; Figure 3).
}
\examples{
null.1 <- generate_null_net(WelshStreams[, 2:18], WelshStreams.prey[, 2:17],
                            sims = 10, c.samples = WelshStreams[, 1],
                            r.samples = WelshStreams.prey[, 1])
# Basic plots, showing the dot and bar plot styles. Increased lower margin
#   on the bar plot so that names fit
plot_preferences(null.1, "Dinocras", signif.level = 0.95, type = "counts",
                 xlab = "Num. of visits", p.cex = 1.2, lwd = 2)

par(mar = c(9, 4, 4, 2) + 0.1)
plot_preferences(null.1, "Dinocras", style = "bars", signif.level = 0.95,
                 type = "counts", ylab = "Num. of visits")

# Same results, this time showing the standardised effect sizes
plot_preferences(null.1, "Rhyacophila", signif.level = 0.95,
                 type = "SES", xlab = "SES")
par(mar = c(9, 4, 4, 2) + 0.1)
plot_preferences(null.1, "Rhyacophila", signif.level = 0.95, style = "bars",
                 type = "SES", ylab = "SES")

}
\references{
Brewer, C.A. (2017) \url{http://www.ColorBrewer.org}

  Davey, J.S., Vaughan, I.P., King, R.A., Bell, J.R., Bohan, D.A., Bruford,
  M.W., Holland, J.M. & Symondson, W.O.C. (2013) Intraguild predation in
  winter wheat: prey choice by a common epigeal carabid consuming spiders.
  \emph{Journal of Applied Ecology}, \strong{50}, 271--279.

  King, R.A, Vaughan, I.P., Bell, J.R., Bohan, D.A, & Symondson, W.O.C.
  (2010) Prey choice by carabid beetles feeding on an earthworm community
  analysed using species- and lineage-specific PCR primers. \emph{Molecular
  Ecology}, \strong{19}, 1721--1732.

  Vaughan, I.P., Gotelli, N.J., Memmott, J., Pearson, C.E., Woodward, G. &
  Symondson, W.O.C. (2018) econullnetr: an R package using null models to
  analyse the structure of ecological networks and identify resource
  selection. \emph{Methods in Ecology and Evolution}, \strong{9}, 728--733.
}
\seealso{
\code{\link{generate_null_net}}, \code{\link{plot_bipartite}}
}
