% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wf_dataset_info.R
\name{wf_dataset_info}
\alias{wf_dataset_info}
\title{List ECMWF Data Store dataset information}
\usage{
wf_dataset_info(dataset, simplify = TRUE)
}
\arguments{
\item{dataset}{character, name of the data set for which the product
information should be loaded}

\item{simplify}{boolean, default \code{TRUE}. If \code{TRUE} the description
will be returned as tidy data instead of a nested list.}
}
\value{
Downloads a tidy data frame with product descriptions from CDS. If
\code{simplify = FALSE} a list with product details will be returned.
}
\description{
Shows and returns detailed product information about a specific data set
(see \code{\link[ecmwfr]{wf_datasets}}). This includes the list of
sub-products in the collection as well as date and time ranges.
}
\examples{
\dontrun{
 # Return information
 info <- wf_dataset_info("reanalysis-era5-single-levels")
 names(info)
}
}
\seealso{
\code{\link[ecmwfr]{wf_datasets}}.
}
\author{
Reto Stauffer, Koen Hufkens
}
