% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wf_request.R
\name{wf_request}
\alias{wf_request}
\title{ECMWF data request and download}
\usage{
wf_request(email, path = tempdir(), time_out = 3600,
  transfer = FALSE, request = list(stream = "oper", levtype = "sfc",
  param = "167.128", dataset = "interim", step = "0", grid = "0.75/0.75",
  time = "00", date = "2014-07-01/to/2014-07-02", type = "an", class =
  "ei", area = "50/10/51/11", format = "netcdf", target = "tmp.nc"),
  verbose = TRUE)
}
\arguments{
\item{email}{email address used to sign up for the ECMWF data service and
used to retrieve the token set by \code{\link[ecmwfr]{wf_set_key}}}

\item{path}{path were to store the downloaded data}

\item{time_out}{how long to wait on a download to start (default = 3600)}

\item{transfer}{logical, download data TRUE or FALSE (default = FALSE)}

\item{request}{nested list with query parameters following the layout
as specified on the ECMWF API page}

\item{verbose}{show feedback on processing}
}
\value{
a download query staging url or a netCDF of data on disk
}
\description{
Stage a data request, and optionally download the data to disk. Alternatively
you can only stage requests, logging the request URLs to submit download
queries later on using \code{\link[ecmwfr]{wf_transfer}}. The function only
allows NetCDF downloads, and will override calls for grib data.
}
\examples{

\donttest{
# set key
wf_set_key(email = "test@mail.com", key = "123")

# get key
wf_get_key(email = "test@mail.com")
}
}
\seealso{
\code{\link[ecmwfr]{wf_set_key}}
\code{\link[ecmwfr]{wf_transfer}}
}
\keyword{climate,}
\keyword{data}
\keyword{download,}
\keyword{re-analysis}
