# load the sample data
set.seed(123)
data(dat, package = "ecic")

# true results ----
ecic1_known <- structure(list(list(coefs = structure(list(perc = c(
  0.1, 0.2,
  0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9
), values = c(
  1.20652792828688,
  1.32026946246403, 1.45963570967079, 1.59069481166298, 1.74650314077746,
  1.92208039132979, 2.12770961519026, 2.37146765883249, 2.78821611280866
)), class = "data.frame", row.names = c(NA, -9L)), name_runs = structure(list(
  i = c(
    1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
    16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30,
    31, 32, 33, 34, 35
  ), qteCohort = c(
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 5, 5, 5, 5
  ), preCohort = c(
    3, 4, 4, 5, 5, 5,
    6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5, 5,
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6
  ), qteYear = c(
    2, 2, 3, 2, 3,
    4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4,
    4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5
  ), preYear = c(
    1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
    2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 4
  ), n1 = c(
    3288L, 3288L,
    3288L, 3288L, 3288L, 3288L, 3288L, 3288L, 3288L, 3288L, 3406L,
    3406L, 3406L, 3406L, 3406L, 3406L, 3406L, 3406L, 3406L, 3406L,
    3406L, 3406L, 3314L, 3314L, 3314L, 3314L, 3314L, 3314L, 3314L,
    3314L, 3314L, 3270L, 3270L, 3270L, 3270L
  ), n0 = c(
    3406L,
    3314L, 3314L, 3270L, 3270L, 3270L, 3432L, 3432L, 3432L, 3432L,
    3314L, 3314L, 3270L, 3270L, 3270L, 3270L, 3432L, 3432L, 3432L,
    3432L, 3432L, 3432L, 3270L, 3270L, 3270L, 3432L, 3432L, 3432L,
    3432L, 3432L, 3432L, 3432L, 3432L, 3432L, 3432L
  )
), class = "data.frame", row.names = c(
  NA,
  -35L
)))), class = c("ecic", "list"), ecic = list(myProbs = c(
  0.1,
  0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9
), es = FALSE, periods_es = NA))

ecic7_known <-
  structure(list(list(coefs = structure(list(perc = c(
    0.1, 0.2,
    0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), values = c(
    1.1824369447982,
    1.30594712799754, 1.44788201220285, 1.57524422238064, 1.73282094342383,
    1.9304999353308, 2.12586499417866, 2.35883364987528, 2.8009323109267
  )), class = "data.frame", row.names = c(NA, -9L)), name_runs = structure(list(
    i = c(
      1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
      16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30,
      31, 32, 33, 34, 35
    ), qteCohort = c(
      2, 2, 2, 2, 2, 2, 2, 2,
      2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4,
      4, 4, 4, 4, 5, 5, 5, 5
    ), preCohort = c(
      3, 4, 4, 5, 5, 5,
      6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5, 5,
      6, 6, 6, 6, 6, 6, 6, 6, 6, 6
    ), qteYear = c(
      2, 2, 3, 2, 3,
      4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4,
      4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5
    ), preYear = c(
      1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
      2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 4
    ), n1 = c(
      3256L, 3256L,
      3335L, 3256L, 3335L, 3229L, 3256L, 3335L, 3229L, 3248L, 3533L,
      3567L, 3533L, 3567L, 3409L, 3443L, 3533L, 3567L, 3409L, 3443L,
      3405L, 3439L, 3237L, 3290L, 3260L, 3237L, 3290L, 3260L, 3327L,
      3380L, 3350L, 3252L, 3182L, 3246L, 3268L
    ), n0 = c(
      3454L,
      3287L, 3257L, 3192L, 3256L, 3278L, 3569L, 3600L, 3517L, 3557L,
      3257L, 3310L, 3256L, 3186L, 3278L, 3208L, 3600L, 3547L, 3517L,
      3464L, 3557L, 3504L, 3278L, 3208L, 3272L, 3517L, 3464L, 3495L,
      3557L, 3504L, 3535L, 3557L, 3504L, 3535L, 3452L
    )
  ), class = "data.frame", row.names = c(
    NA,
    -35L
  )))), class = c("ecic", "list"), ecic = list(myProbs = c(
    0.1,
    0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), es = FALSE, periods_es = NA))
ecic8_known <-
  structure(list(list(coefs = structure(list(perc = c(
    0.1, 0.2,
    0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), values = c(
    1.19157703423353,
    1.32424773233639, 1.47080625365283, 1.61557450411822, 1.77360068479517,
    1.94383524685349, 2.12881130764858, 2.37821990612436, 2.81219797320025
  )), class = "data.frame", row.names = c(NA, -9L)), name_runs = structure(list(
    i = c(
      1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
      16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30,
      31, 32, 33, 34, 35
    ), qteCohort = c(
      2, 2, 2, 2, 2, 2, 2, 2,
      2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4,
      4, 4, 4, 4, 5, 5, 5, 5
    ), preCohort = c(
      3, 4, 4, 5, 5, 5,
      6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5, 5,
      6, 6, 6, 6, 6, 6, 6, 6, 6, 6
    ), qteYear = c(
      2, 2, 3, 2, 3,
      4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4,
      4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5
    ), preYear = c(
      1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
      2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 4
    ), n1 = c(
      3375L, 3375L,
      3319L, 3375L, 3319L, 3290L, 3375L, 3319L, 3290L, 3331L, 3424L,
      3444L, 3424L, 3444L, 3430L, 3450L, 3424L, 3444L, 3430L, 3450L,
      3370L, 3390L, 3308L, 3322L, 3265L, 3308L, 3322L, 3265L, 3242L,
      3256L, 3199L, 3199L, 3241L, 3214L, 3220L
    ), n0 = c(
      3450L,
      3292L, 3235L, 3310L, 3283L, 3289L, 3525L, 3481L, 3434L, 3389L,
      3235L, 3249L, 3283L, 3325L, 3289L, 3331L, 3481L, 3506L, 3434L,
      3459L, 3389L, 3414L, 3289L, 3331L, 3304L, 3434L, 3459L, 3415L,
      3389L, 3414L, 3370L, 3389L, 3414L, 3370L, 3323L
    )
  ), class = "data.frame", row.names = c(
    NA,
    -35L
  )))), class = c("ecic", "list"), ecic = list(myProbs = c(
    0.1,
    0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), es = FALSE, periods_es = NA))
es1_known <-
  structure(list(list(coefs = list(structure(list(perc = c(
    0.1,
    0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), values = c(
    0.865448002563489,
    0.942178519639249, 0.979270941287332, 1.01425319589877, 1.08966100184306,
    1.14495411044133, 1.20147496852804, 1.249495760647, 1.3658262137128
  )), class = "data.frame", row.names = c(NA, -9L)), structure(list(
    perc = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9), values = c(
      2.3847433952092,
      2.37187657625476, 2.41642305993792, 2.43492106278433, 2.47545764099731,
      2.51853027201251, 2.57554595566277, 2.64453836042537, 2.76088859987476
    )
  ), class = "data.frame", row.names = c(NA, -9L)), structure(list(
    perc = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9), values = c(
      3.15153520907358,
      3.22576539752037, 3.26525461744654, 3.29753370146498, 3.36826784967731,
      3.44429954229601, 3.50128962426078, 3.55421738561253, 3.68232932095826
    )
  ), class = "data.frame", row.names = c(NA, -9L)), structure(list(
    perc = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9), values = c(
      4.68156337391829,
      4.6596562423801, 4.70735836362679, 4.73592899710217, 4.79016225743993,
      4.85704741003153, 4.90261666562302, 4.90807793440994, 5.04701493801469
    )
  ), class = "data.frame", row.names = c(NA, -9L))), name_runs = structure(list(
    i = c(
      1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
      16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30,
      31, 32, 33, 34, 35
    ), qteCohort = c(
      2, 2, 2, 2, 2, 2, 2, 2,
      2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4,
      4, 4, 4, 4, 5, 5, 5, 5
    ), preCohort = c(
      3, 4, 4, 5, 5, 5,
      6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5, 5,
      6, 6, 6, 6, 6, 6, 6, 6, 6, 6
    ), qteYear = c(
      2, 2, 3, 2, 3,
      4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4,
      4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5
    ), preYear = c(
      1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
      2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 4
    ), n1 = c(
      3256L, 3256L,
      3335L, 3256L, 3335L, 3229L, 3256L, 3335L, 3229L, 3248L, 3533L,
      3567L, 3533L, 3567L, 3409L, 3443L, 3533L, 3567L, 3409L, 3443L,
      3405L, 3439L, 3237L, 3290L, 3260L, 3237L, 3290L, 3260L, 3327L,
      3380L, 3350L, 3252L, 3182L, 3246L, 3268L
    ), n0 = c(
      3454L,
      3287L, 3257L, 3192L, 3256L, 3278L, 3569L, 3600L, 3517L, 3557L,
      3257L, 3310L, 3256L, 3186L, 3278L, 3208L, 3600L, 3547L, 3517L,
      3464L, 3557L, 3504L, 3278L, 3208L, 3272L, 3517L, 3464L, 3495L,
      3557L, 3504L, 3535L, 3557L, 3504L, 3535L, 3452L
    ), diff = c(
      0,
      0, 1, 0, 1, 2, 0, 1, 2, 3, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1,
      2, 2, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0
    )
  ), row.names = c(
    NA,
    -35L
  ), class = "data.frame")), list(coefs = list(structure(list(
    perc = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9), values = c(
      0.912595355484534,
      0.971079611194766, 0.992047246696235, 1.0509123905015, 1.10582966606653,
      1.15480593315162, 1.19689305432596, 1.23918820504652, 1.35553548434629
    )
  ), class = "data.frame", row.names = c(NA, -9L)), structure(list(
    perc = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9), values = c(
      2.37213740420442,
      2.38254261257374, 2.40339649344639, 2.43640846679598, 2.48142168318733,
      2.51015314631627, 2.55963244626479, 2.60488158026126, 2.69803044214262
    )
  ), class = "data.frame", row.names = c(NA, -9L)), structure(list(
    perc = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9), values = c(
      3.10286569423147,
      3.12939866791464, 3.20327873830594, 3.27654527405252, 3.36228617973964,
      3.42199008355847, 3.47091040374992, 3.53711935185794, 3.66196360906251
    )
  ), class = "data.frame", row.names = c(NA, -9L)), structure(list(
    perc = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9), values = c(
      4.49094803313735,
      4.5758765199035, 4.59407228633117, 4.63929593793898, 4.74439928556024,
      4.8072642562159, 4.91122619730177, 4.92459324329222, 5.04620219791541
    )
  ), class = "data.frame", row.names = c(NA, -9L))), name_runs = structure(list(
    i = c(
      1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
      16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30,
      31, 32, 33, 34, 35
    ), qteCohort = c(
      2, 2, 2, 2, 2, 2, 2, 2,
      2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4,
      4, 4, 4, 4, 5, 5, 5, 5
    ), preCohort = c(
      3, 4, 4, 5, 5, 5,
      6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5, 5,
      6, 6, 6, 6, 6, 6, 6, 6, 6, 6
    ), qteYear = c(
      2, 2, 3, 2, 3,
      4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4,
      4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5
    ), preYear = c(
      1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
      2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 4
    ), n1 = c(
      3167L, 3167L,
      3205L, 3167L, 3205L, 3261L, 3167L, 3205L, 3261L, 3289L, 3455L,
      3433L, 3455L, 3433L, 3491L, 3469L, 3455L, 3433L, 3491L, 3469L,
      3463L, 3441L, 3372L, 3302L, 3280L, 3372L, 3302L, 3280L, 3286L,
      3216L, 3194L, 3168L, 3198L, 3191L, 3197L
    ), n0 = c(
      3386L,
      3352L, 3330L, 3160L, 3153L, 3159L, 3484L, 3583L, 3533L, 3553L,
      3330L, 3260L, 3153L, 3183L, 3159L, 3189L, 3583L, 3543L, 3533L,
      3493L, 3553L, 3513L, 3159L, 3189L, 3182L, 3533L, 3493L, 3592L,
      3553L, 3513L, 3612L, 3553L, 3513L, 3612L, 3562L
    ), diff = c(
      0,
      0, 1, 0, 1, 2, 0, 1, 2, 3, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1,
      2, 2, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0
    )
  ), row.names = c(
    NA,
    -35L
  ), class = "data.frame")), list(coefs = list(structure(list(
    perc = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9), values = c(
      0.93864819313792,
      0.96502375558316, 1.00347805422387, 1.05919500557579, 1.10454831480542,
      1.13357119804896, 1.18060746995821, 1.22372338976779, 1.34641847717894
    )
  ), class = "data.frame", row.names = c(NA, -9L)), structure(list(
    perc = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9), values = c(
      2.38540539118976,
      2.39165031812018, 2.42766206009637, 2.46691345990796, 2.48222276389431,
      2.52407304857569, 2.57374710104228, 2.62402602410689, 2.71062559944365
    )
  ), class = "data.frame", row.names = c(NA, -9L)), structure(list(
    perc = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9), values = c(
      3.13711231009373,
      3.16705083352147, 3.24012851605335, 3.30066979413401, 3.36548509940758,
      3.4396349125055, 3.49342413697079, 3.55753503902009, 3.67513882833301
    )
  ), class = "data.frame", row.names = c(NA, -9L)), structure(list(
    perc = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9), values = c(
      4.65247680082085,
      4.63603940901666, 4.65759233357687, 4.67691850053922, 4.74690382886969,
      4.80402271354412, 4.91312125405358, 4.92840785532268, 5.06683757371943
    )
  ), class = "data.frame", row.names = c(NA, -9L))), name_runs = structure(list(
    i = c(
      1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
      16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30,
      31, 32, 33, 34, 35
    ), qteCohort = c(
      2, 2, 2, 2, 2, 2, 2, 2,
      2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4,
      4, 4, 4, 4, 5, 5, 5, 5
    ), preCohort = c(
      3, 4, 4, 5, 5, 5,
      6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5, 5,
      6, 6, 6, 6, 6, 6, 6, 6, 6, 6
    ), qteYear = c(
      2, 2, 3, 2, 3,
      4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4,
      4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5
    ), preYear = c(
      1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
      2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 4
    ), n1 = c(
      3223L, 3223L,
      3201L, 3223L, 3201L, 3292L, 3223L, 3201L, 3292L, 3285L, 3469L,
      3424L, 3469L, 3424L, 3486L, 3441L, 3469L, 3424L, 3486L, 3441L,
      3487L, 3442L, 3410L, 3349L, 3275L, 3410L, 3349L, 3275L, 3319L,
      3258L, 3184L, 3245L, 3195L, 3160L, 3205L
    ), n0 = c(
      3423L,
      3347L, 3273L, 3244L, 3209L, 3254L, 3637L, 3550L, 3445L, 3546L,
      3273L, 3212L, 3209L, 3159L, 3254L, 3204L, 3550L, 3663L, 3445L,
      3558L, 3546L, 3659L, 3254L, 3204L, 3169L, 3445L, 3558L, 3471L,
      3546L, 3659L, 3572L, 3546L, 3659L, 3572L, 3467L
    ), diff = c(
      0,
      0, 1, 0, 1, 2, 0, 1, 2, 3, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1,
      2, 2, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0
    )
  ), row.names = c(
    NA,
    -35L
  ), class = "data.frame"))), class = c("ecic", "list"), ecic = list(
    myProbs = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9),
    es = TRUE, periods_es = 3
  ))


summary1_known <-
  structure(list(perc = c(
    0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8,
    0.9
  ), coefs = c(
    1.20652792828688, 1.32026946246403, 1.45963570967079,
    1.59069481166298, 1.74650314077746, 1.92208039132979, 2.12770961519026,
    2.37146765883249, 2.78821611280866
  ), se = c(
    NA_real_, NA_real_,
    NA_real_, NA_real_, NA_real_, NA_real_, NA_real_, NA_real_, NA_real_
  )), class = c("ecic_table", "data.frame"), row.names = c(
    NA,
    -9L
  ), ecic_table = list(es = FALSE, periods_es = NA, myProbs = c(
    0.1,
    0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  )))
summary2_known <-
  structure(list(structure(list(perc = c(
    0.1, 0.2, 0.3, 0.4, 0.5,
    0.6, 0.7, 0.8, 0.9
  ), es = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L), coefs = c(
    0.905563850395315, 0.959427295472392, 0.991598747402479,
    1.04145353065869, 1.10001299423834, 1.14444374721397, 1.1929918309374,
    1.2374691184871, 1.35592672507934
  ), se = c(
    0.0371032144550582,
    0.0152416714176516, 0.0121097870705044, 0.0239174431410618, 0.0089879516675098,
    0.010626563258544, 0.010967122780657, 0.0129719011379584, 0.00970978173417693
  )), class = "data.frame", row.names = c(NA, -9L)), structure(list(
    perc = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9), es = c(
      1L,
      1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L
    ), coefs = c(
      2.38076206353446,
      2.38202316898289, 2.41582720449356, 2.44608099649609, 2.47970069602632,
      2.51758548896815, 2.56964183432328, 2.62448198826451, 2.72318154715367
    ), se = c(
      0.0074765046036894, 0.0098970997303856, 0.0121437520558553,
      0.0180567644257941, 0.0036963589597282, 0.00700787992038788,
      0.00871492148361322, 0.0198323216172744, 0.0332569671729449
    )
  ), class = "data.frame", row.names = c(NA, -9L)), structure(list(
    perc = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9), es = c(
      2L,
      2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L
    ), coefs = c(
      3.13050440446626,
      3.17407163298549, 3.23622062393528, 3.29158292321717, 3.36534637627484,
      3.43530817945333, 3.48854138832716, 3.54962392549685, 3.67314391945126
    ), se = c(
      0.0249985745859188, 0.0485654750060311, 0.0311722009877002,
      0.0131170476330048, 0.00299324688114135, 0.0117672618509565,
      0.0157672186973337, 0.0109555911502502, 0.0103283736057534
    )
  ), class = "data.frame", row.names = c(NA, -9L)), structure(list(
    perc = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9), es = c(
      3L,
      3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L
    ), coefs = c(
      4.60832940262549,
      4.62385739043342, 4.65300766117828, 4.68404781186012, 4.76048845728995,
      4.82277812659718, 4.90898803899279, 4.92035967767495, 5.05335156988317
    ), se = c(
      0.102690294628182, 0.0431979357971626, 0.056782023942521,
      0.0487094173722279, 0.0257287581473103, 0.0297222936539341,
      0.00559853632531547, 0.0108059580536119, 0.011686289454775
    )
  ), class = "data.frame", row.names = c(NA, -9L))), class = c(
    "ecic_table",
    "list"
  ), ecic_table = list(es = TRUE, periods_es = 3, myProbs = c(
    0.1,
    0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  )))

# tests ----
# average
# results from ecic(.) |> dput()
ecic1 <- ecic(yvar = lemp, gvar = first.treat, tvar = year, ivar = countyreal, dat = dat) # ngives o se
ecic1a <- ecic(yvar = "lemp", gvar = "first.treat", tvar = "year", ivar = "countyreal", dat = dat, boot = NULL) # gives no se

expect_error(ecic(yvar = lemp, gvar = first.treat, tvar = year, ivar = countyreal)) # error
expect_error(ecic(yvar = lemp, gvar = first.tat, tvar = year, ivar = countyreal, dat = dat)) # error
expect_error(ecic(yvar = lemp, gvar = first.treat, tvar = year, ivar = countyreal, dat = dat, nReps = 0)) # error
expect_warning(ecic(yvar = lemp, gvar = first.treat, tvar = year, ivar = countyreal, dat = dat, nReps = 100)) # warning
expect_error(ecic(yvar = lemp, gvar = first.treat, tvar = year, ivar = countyreal, dat = dat, boot = "blaa")) # error
ecic7 <- ecic(yvar = lemp, gvar = first.treat, tvar = year, ivar = countyreal, dat = dat, boot = "weighted")
ecic8 <- ecic(yvar = lemp, gvar = first.treat, tvar = year, ivar = countyreal, dat = dat, boot = "normal")

expect_equal(ecic1, ecic1_known)
expect_equal(ecic1a, ecic1_known)
expect_equal(ecic7, ecic7_known)
expect_equal(ecic8, ecic8_known)

# ES
es1 <- ecic(
  yvar = "lemp", gvar = "first.treat", tvar = "year", ivar = "countyreal", dat = dat,
  boot = "weighted", nReps = 3, es = T
)

expect_equal(es1, es1_known)

# summary
sum1 <- summary(ecic1)
sum2 <- summary(es1)

expect_equal(sum1, summary1_known)
expect_equal(sum2, summary2_known)

# plot
expect_error(plot_ecic(sum2, es_type = "nos")) # error
expect_error(plot(es2))
