% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echarty.R
\name{ec.clmn}
\alias{ec.clmn}
\title{Data column}
\usage{
ec.clmn(col = NULL, ...)
}
\arguments{
\item{col}{A column index(number), column name(string) or a \code{\link[base]{sprintf}} format string. \cr}

\item{...}{Comma separated list of column indexes or names, when \emph{col} is \emph{sprintf}. This allows formatting of multiple columns, as for a tooltip.}
}
\description{
Helper function to address data column(s) by index or name
}
\details{
Column indexes are counted in R and start at 1.\cr
\emph{col} as sprintf supports only two placeholders - \%d for numeric and \%s for string.\cr
\emph{col} as sprintf can contain double quotes, but not single or backquotes.\cr
Useful to set formatter, color, symbolSize, etc.
}
\examples{
tmp <- data.frame(Species = as.vector(unique(iris$Species)),
                  emoji = c('\U0001F33B','\U0001F335','\U0001F33A')) # ðŸŒ»,ðŸŒµ,ðŸŒº
df <- iris \%>\% dplyr::inner_join(tmp)   # add 6th column 'emoji'
p <- df \%>\% dplyr::group_by(Species) \%>\% ec.init()
p$x$opts$series <- list(list(
  type='scatter', label=list(show=TRUE, formatter = ec.clmn(6))  # 6th column
))
p$x$opts$tooltip <- list(formatter=
   ec.clmn('species <b>\%d</b><br>s.len <b>\%d</b><br>s.wid <b>\%d</b>', 5,1,2))
p

}
