% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R, R/add_.R
\name{e_histogram}
\alias{e_histogram}
\alias{e_density}
\alias{e_histogram_}
\alias{e_density_}
\title{Histogram & Density}
\usage{
e_histogram(
  e,
  serie,
  breaks = "Sturges",
  name = NULL,
  legend = TRUE,
  bar_width = "99\%",
  x_index = 0,
  y_index = 0,
  ...
)

e_density(
  e,
  serie,
  breaks = "Sturges",
  name = NULL,
  legend = TRUE,
  x_index = 0,
  y_index = 0,
  smooth = TRUE,
  ...
)

e_histogram_(
  e,
  serie,
  breaks = "Sturges",
  name = NULL,
  legend = TRUE,
  bar_width = "90\%",
  x_index = 0,
  y_index = 0,
  ...
)

e_density_(
  e,
  serie,
  breaks = "Sturges",
  name = NULL,
  legend = TRUE,
  x_index = 0,
  y_index = 0,
  smooth = TRUE,
  ...
)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{serie}{Column name of serie to plot.}

\item{breaks}{Passed to \code{\link{hist}}.}

\item{name}{name of the serie.}

\item{legend}{Whether to add serie to legend.}

\item{bar_width}{Width of bars.}

\item{x_index, y_index}{Indexes of x and y axis.}

\item{...}{Any other option to pass, check See Also section.}

\item{smooth}{Whether to use smoothed lines, passed to \code{\link{e_line}}.}
}
\description{
Add a histogram or density plots.
}
\examples{
mtcars |>
  e_charts() |>
  e_histogram(mpg, name = "histogram") |>
  e_density(mpg, areaStyle = list(opacity = .4), smooth = TRUE, name = "density", y_index = 1) |>
  e_tooltip(trigger = "axis")

# timeline
mtcars |>
  group_by(cyl) |>
  e_charts(timeline = TRUE) |>
  e_histogram(mpg, name = "histogram") |>
  e_density(mpg, name = "density", y_index = 1)
}
\seealso{
\href{https://echarts.apache.org/en/option.html#series-bar}{Additional arguments for histogram},
 \href{https://echarts.apache.org/en/option.html#series-line}{Additional arguments for density}
}
