% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{e_visual_map}
\alias{e_visual_map}
\alias{e_visual_map_}
\title{Visual Map}
\usage{
e_visual_map(
  e,
  serie,
  calculable = TRUE,
  type = c("continuous", "piecewise"),
  scale = NULL,
  ...
)

e_visual_map_(
  e,
  serie = NULL,
  calculable = TRUE,
  type = c("continuous", "piecewise"),
  scale = NULL,
  ...
)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or 
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{serie}{Column name of serie to scale against.}

\item{calculable}{Whether show handles, which can be dragged to adjust "selected range".}

\item{type}{One of \code{continuous} or \code{piecewise}.}

\item{scale}{A function that takes a vector of \code{numeric} and returns a vector of \code{numeric}
of the same length.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Visual Map
}
\section{Scaling function}{
 defaults to \code{e_scale} which is a basic function that rescales \code{size}
between 1 and 20 for that makes for decent sized points on the chart.
}

\examples{
# scaled data
mtcars \%>\% 
  e_charts(mpg) \%>\% 
  e_scatter(wt, qsec, scale = e_scale) \%>\% 
  e_visual_map(qsec, scale = e_scale)

# dimension
# color according to y axis
mtcars \%>\% 
  e_charts(mpg) \%>\% 
  e_scatter(wt) \%>\% 
  e_visual_map(wt, dimension = 1)
  
# color according to x axis
mtcars \%>\% 
  e_charts(mpg) \%>\% 
  e_scatter(wt) \%>\% 
  e_visual_map(mpg, dimension = 0)

v <- LETTERS[1:10]
matrix <- data.frame(
  x = sample(v, 300, replace = TRUE), 
  y = sample(v, 300, replace = TRUE), 
  z = rnorm(300, 10, 1),
  color = rnorm(300, 10, 1),
  size = rnorm(300, 10, 1),
  stringsAsFactors = FALSE
) \%>\% 
  dplyr::group_by(x, y) \%>\% 
  dplyr::summarise(
    z = sum(z),
    color = sum(color),
    size = sum(size)
  ) \%>\% 
  dplyr::ungroup() 
  
matrix \%>\% 
  e_charts(x) \%>\% 
  e_scatter_3d(y, z, color, size) \%>\% 
  e_visual_map(
    z, # scale to z
    inRange = list(symbolSize = c(1, 30)), # scale size
    dimension = 3 # third dimension 0 = x, y = 1, z = 2, size = 3
  ) \%>\% 
  e_visual_map(
    z, # scale to z
    inRange = list(color = c('#bf444c', '#d88273', '#f6efa6')), # scale colors
    dimension = 4, # third dimension 0 = x, y = 1, z = 2, size = 3, color = 4
    bottom = 300 # padding to avoid visual maps overlap
  )

}
\seealso{
\href{https://echarts.apache.org/en/option.html#visualMap}{Additional arguments}
}
