% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.R
\name{callbacks}
\alias{callbacks}
\alias{e_on}
\alias{e_off}
\title{Callbacks}
\usage{
e_on(e, query, handler, event = "click")

e_off(e, query, handler, event = "click")
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or 
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{query}{Condistion that triggers the handler}

\item{handler}{JavaSscript handler, passed to \link[htmlwidgets]{JS}.}

\item{event}{Event that triggers the handler.}
}
\description{
Binds events to chart interactions.
}
\examples{
cars \%>\% 
  e_charts(speed) \%>\% 
  e_scatter(dist) \%>\% 
  e_on(
    list(seriesName = "dist"),
    "function(){alert('Serie clicked')}"
  )

}
\seealso{
\href{https://echarts.apache.org/en/api.html#echartsInstance.on}{official documentation}
}
