% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeline.R
\name{timeline-opts}
\alias{timeline-opts}
\alias{e_timeline_opts}
\alias{e_timeline_serie}
\title{Timeline}
\usage{
e_timeline_opts(e, axis_type = "category", ...)

e_timeline_serie(e, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}}.}

\item{axis_type}{Type of axis, \code{time}, \code{value}, or \code{category}}

\item{...}{Named options.}
}
\description{
Set timeline options
}
\section{Functions}{

\itemize{
  \item{\code{e_timeline_opts}: Pass general timeline options, see \href{https://ecomfe.github.io/echarts-doc/public/en/option.html#timeline}{official documentation}.}
  \item{\code{e_timeline_serie}: Pass options to each serie, each options \emph{must}  be a vector or list the same length as their are steps, see examples.}
  \item{\code{e_timeline_make}: Helper function that wraps your data and \code{e_timeline_serie} to dynamically add options to series.}
}
}

\examples{
# general options
iris \%>\% 
  group_by(Species) \%>\% 
  e_charts(Sepal.Length, timeline = TRUE) \%>\% 
  e_line(Sepal.Width) \%>\% 
  e_timeline_opts(
    autoPlay = TRUE,
    rewind = TRUE
  )
  
# serie options
iris \%>\% 
  group_by(Species) \%>\% 
  e_charts(Sepal.Length, timeline = TRUE) \%>\% 
  e_line(Sepal.Width) \%>\% 
    e_timeline_serie(
      title = list(
        list(text = "setosa"),
        list(text = "versicolor"),
        list(text = "virginica")
      )
    )

}
