% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R, R/add_.R
\name{e_area}
\alias{e_area}
\alias{e_area_}
\title{Area}
\usage{
e_area(e, serie, bind, name = NULL, legend = TRUE, y_index = 0,
  x_index = 0, coord_system = "cartesian2d", ...)

e_area_(e, serie, bind = NULL, name = NULL, legend = TRUE,
  y_index = 0, x_index = 0, coord_system = "cartesian2d", ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}}.}

\item{serie}{Column name of serie to plot.}

\item{bind}{Binding between datasets, namely for use of \code{\link{e_brush}}.}

\item{name}{name of the serie.}

\item{legend}{Whether to add serie to legend.}

\item{y_index}{Indexes of x and y axis.}

\item{x_index}{Indexes of x and y axis.}

\item{coord_system}{Coordinate system to plot against.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Add area serie.
}
\examples{
CO2 \%>\% 
  group_by(Plant) \%>\% 
  e_charts(conc) \%>\% 
  e_area(uptake) \%>\% 
  e_tooltip(trigger = "axis")

# timeline  
iris \%>\% 
  group_by(Species) \%>\% 
  e_charts(Sepal.Length, timeline = TRUE) \%>\% 
  e_area(Sepal.Width) \%>\% 
  e_tooltip(trigger = "axis")

}
\seealso{
\href{https://ecomfe.github.io/echarts-doc/public/en/option.html#series-line}{Additional arguments}
}
