% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R, R/add_.R
\name{e_flow_gl}
\alias{e_flow_gl}
\alias{e_flow_gl_}
\title{Flow GL}
\usage{
e_flow_gl(e, y, sx, sy, color, name = NULL, coord.system = NULL,
  rm.x = TRUE, rm.y = TRUE, ...)

e_flow_gl_(e, y, sx, sy, color = NULL, name = NULL,
  coord.system = NULL, rm.x = TRUE, rm.y = TRUE, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}}.}

\item{y}{Vector position on the y axis.}

\item{sx, sy}{Velocity in respective axis.}

\item{color}{Vector color.}

\item{name}{name of the serie.}

\item{coord.system}{Coordinate system to use.}

\item{rm.x, rm.y}{Whether to remove x and y axis, only applies if \code{coord.system} is not \code{null}.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Flow GL
}
\examples{
# coordinates
vectors <- expand.grid(0:9, 0:9)
names(vectors) <- c("x", "y")
vectors$sx <- rnorm(100)
vectors$sy <- rnorm(100)
vectors$color <- log10(runif(100, 1, 10))

vectors \%>\% 
  e_charts(x) \%>\% 
  e_flow_gl(y, sx, sy, color) \%>\% 
  e_visual_map(
    min = 0, max = 1, # log 10
    dimension = 4, # x = 0, y = 1, sx = 3, sy = 4
    show = FALSE, # hide
    inRange = list(
      color = c('#313695', '#4575b4', '#74add1', '#abd9e9', '#e0f3f8',
                '#ffffbf', '#fee090', '#fdae61', '#f46d43', '#d73027', '#a50026')
    )
  ) \%>\% 
  e_x_axis(
    splitLine = list(show = FALSE)
  ) \%>\% 
  e_y_axis(
    splitLine = list(show = FALSE)
  )   
  
# map
latlong <- seq(-180, 180, by = 5)
wind = expand.grid(lng = latlong, lat = latlong)
wind$slng <- rnorm(nrow(wind), 0, 200)
wind$slat <- rnorm(nrow(wind), 0, 200)
wind$color <- abs(wind$slat) - abs(wind$slng)
rng <- range(wind$color)

trans <- list(opacity = 0.5) # transparency

wind \%>\% 
  e_charts(lng, backgroundColor = '#333') \%>\% 
  e_geo(
    itemStyle = list(
      normal = list(
        areaColor = "#323c48",
        borderColor = "#111"
      )
    )
  ) \%>\% 
  e_flow_gl(lat, slng, slat, color, 
    coord.system = "geo", 
    itemStyle = trans,
    particleSize = 2
  ) \%>\% 
  e_visual_map(
    min = rng[1], max = rng[2], # range
    dimension = 4, # lng = 0, lat = 1, slng = 2, slat = 3, color = 4
    show = FALSE, # hide
    inRange = list(
      color = c('#313695', '#4575b4', '#74add1', '#abd9e9', '#e0f3f8', 
                '#ffffbf', '#fee090', '#fdae61', '#f46d43', '#d73027', '#a50026')
    )
  )

}
\seealso{
\href{Additional arguments}{http://echarts.baidu.com/option-gl.html#series-flowGL}
}
