% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/todate.R
\name{todate}
\alias{todate}
\title{Convert to Date}
\usage{
todate(
  x,
  nastrings = easyr::nastrings,
  aggressive.extraction = TRUE,
  preprocessed.values = NULL,
  ifna = c("return-unchanged", "error", "warning", "return-na"),
  verbose = TRUE,
  allow_times = FALSE,
  do.month.char = TRUE,
  do.excel = TRUE,
  min.acceptable = lubridate::ymd("1920-01-01"),
  max.acceptable = lubridate::ymd("2050-01-01")
)
}
\arguments{
\item{x}{Value or vector to be converted.}

\item{nastrings}{Vector of characters to be considered NAs. todate will treat these like NAs. Defaults to the easyr::nastrings list.}

\item{aggressive.extraction}{todate will take dates inside long strings (like filenames) and convert them to dates. This seems to be the preferred outcome, so we leave it as default (TRUE). However, if you want to avoid this you can do so via this option (FALSE).}

\item{preprocessed.values}{Strings need to have NAs set, lowercase and be trimmed before they can be checked. To avoid doing this multiple times, you can pass these processed values to the function.}

\item{ifna}{Action to take if NAs are created. 'return-unchanged'  returns the sent vector unchanged; 'warning' results in a warning and returns the converted vector with new NAs; 'error' results in an error; 'return-na' returns new NAs without a warning.}

\item{verbose}{Choose to view messaging.}

\item{allow_times}{Set to TRUE to allow DateTimes as output, otherwise this will always convert to Dates (losing time information). This is better for binding data, hence the default FALSE.}

\item{do.month.char}{Attempt to convert month names in text. lubridate does this by default, but sometimes it can result in inaccurate dates. For example, "Feb 2017" is converted to 2-20-2017 even though no day was given.}

\item{do.excel}{Check for excel-formatted numbers.}

\item{min.acceptable}{Set NA if converted value is less than this value. Helps to prevent numbers from being assumed as dates. Set NULL to skip this check. Does not affect character conversions.}

\item{max.acceptable}{Set NA if converted value is greater than this value. Helps to prevent numbers from being assumed as dates. Set NULL to skip this check. Does not affect character conversions.}
}
\value{
Converted vector using lubridate::parse_date_time(x,c('mdy','ymd','dmy'))
}
\description{
Flexible date conversion function using lubridate. Works with dates in many formats, without needing to know the format in advance. 
Only use this if you don't know the format of the dates before hand. Otherwise, lubridate functions parse_date_time, mdy, etc. should be used.
Author: Bryce Chamberlain. Tech review: Dominic Dillingham.
}
\examples{
x <- c( '20171124', '2017/12/24', NA, '12/24/2017', '5/11/2017 1:51PM' ) 
x2 <- todate(x)
x2
}
