% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkeq.R
\name{checkeq}
\alias{checkeq}
\title{Check Value or Control Total}
\usage{
checkeq(expected, actual, desc = "", acceptable_pct_diff = 1e-08, digits = 2)
}
\arguments{
\item{expected}{The expected value of the metric.}

\item{actual}{The actual value of the metric.}

\item{desc}{(Optional) Description of the metric being checked.}

\item{acceptable_pct_diff}{(Optional) Acceptable percentage difference when checking values. Checked as an absolute value.}

\item{digits}{(Optional) Digits to round to. Without rounding you get errors from floating values. Set to NA to avoid rounding.}
}
\value{
Message (via cat) indicating success or errors out in case of failure.
}
\description{
Check actual versus expected values and get helpful metrics back.
Author: Bryce Chamberlain. Tech review: Lindsay Smeltzer.
}
\examples{
checkeq(expected=100,actual=100,desc='A Match')
}
