% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{cache.ok}
\alias{cache.ok}
\title{Check Cache Status}
\usage{
cache.ok(cache.num, do.load = TRUE)
}
\arguments{
\item{cache.num}{The index/number for the cache we are checking in the cache.info list.}

\item{do.load}{Load the cache if it is found.}
}
\value{
Boolean indicating if the cache is acceptable. FALSE indicates the cache doesn't exist or is invalid so code should be run again.
}
\description{
Check a cache and if necessary clear it to trigger a re-cache.
}
\examples{
# check the first cache to see if it exists and dependent files haven't changed.
# if this is TRUE, code in brackets will get skipped and the cache will be loaded instead.
# set do.load = FALSE if you have multiple files that build a cache, 
#    to prevent multiple cache loads.
# output will be printed to the console to tell you if the cache was loaded or re-built.
if( ! cache.ok(1) ){

  # do stuff
  
  # if this is the final file for this cache, end with save.cache to save passed objects as a cache.
  save.cache(iris)
}
}
