% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/count2prob.R
\name{count2prob}
\alias{count2prob}
\title{Convert counts to probabilities}
\usage{
count2prob(x, type = 3)
}
\arguments{
\item{x}{input matrix of counts from \code{\link{convert2prob}}}

\item{type}{selection of plotting positions (default to 3, see Types)}
}
\value{
Matrix of probabilities per category
}
\description{
Using plotting positions as described in Wilks (2011), counts of
occurences per forecast category are converted to probabilities
of occurence. For ensembles of size 1 (e.g. verifying observations),
the count vector is returned unaltered (corresponding to occurence
probabilities of 0 or 1).
}
\section{Types}{


The types characterize the plotting positions as specified in Wilks (2011). The
plotting positions are computed using the following relationship:

\deqn{p(x_i) = \frac{i + 1 - a}{n + 1 - a}}{p(x_i) = (i + 1 - a)/(n + 1 - a)}

where i is the number of ensemble members not exceeding x, and n is the
number of ensemble members. The types are characterized as follows:

\tabular{clc}{
  type \tab description \tab a \cr
  1 \tab Weibull \tab 0 \cr
  2 \tab Bernard and Bos-Levenbach \tab 0.3 \cr
  3 \tab Tukey \tab 1/3 \cr
  4 \tab Gumbel \tab 1 \cr
  5 \tab Hazen \tab 1/2 \cr
  6 \tab Cunnane \tab 2/5
}
}
\examples{
tm <- toymodel()

## convert to tercile forecasts (only display first forecast and obs)
count2prob(convert2prob(tm$fcst, prob=1:2/3))[1,]
count2prob(convert2prob(tm$obs, prob=1:2/3))[1,]
}
\references{
Wilks, D.S. (2011). Statistical methods in the atmospheric sciences (Third Edition).
Academic press.
}
\seealso{
\code{\link{convert2prob}} for conversion of continuous forecasts to ensemble counts
}
\keyword{utilities}

