% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int.R
\name{interact.part}
\alias{interact.part}
\title{Compute a chosen set of pairwise interactions between two sets of columns in a data matrix}
\usage{
interact.part(input, first, second)
}
\arguments{
\item{input}{The input data matrix, of either class matrix or data.frame}

\item{first}{The first set of columns to combine with each of the members of the second set, as either integers or column names}

\item{second}{The second set of columns to combine with each of the members of the first set, as either integers or column names}
}
\value{
A data matrix with multiplied columns as indicated using the sets 'first' and 'second'
}
\description{
Similar to interact.all-function, but here user provides two sets of variables, and each pairwise combination between these two sets is multiplied. These pairwise interactions are then returned as a new data matrix, with a colon indicating which variables were multiplied.
}
\examples{
set.seed(1)
somedata <- data.frame(a = rnorm(10), b = rnorm(10), c = runif(10), d = runif(10))
somedata
someinteract <- interact.part(somedata, first = c("a", "b"), second = c("c", "d"))
someinteract
}
