% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semantic_enrich.R
\name{join_vars_to_ontol}
\alias{join_vars_to_ontol}
\title{Join Mapping Table to Ontology Network Graph}
\usage{
join_vars_to_ontol(ontol_graph, var2entity_tbl, mode = "in", root, k = 0.5)
}
\arguments{
\item{ontol_graph}{Graph containing the chosen ontology. Must be in
\code{\link[tidygraph:tidygraph]{tidygraph}} format or coercible to this format.}

\item{var2entity_tbl}{Edge table containing dataset variable names in first
column and entities in ontologies to which they are mapped in the second
column.}

\item{mode}{Character constant specifying the directionality of the edges.
One of "in" or "out".}

\item{root}{name of root node identifier in column 1 to calculate node depth
from.}

\item{k}{numeric value to adjust the weight of the two items of information
content equation (relative number of hyponyms/descendants and relative node
depth). Default = 0.5}
}
\value{
A \code{\link{tidygraph}} resulting from the joining of \code{var2entity_tbl}
  and \code{ontol_graph}.
}
\description{
This function creates new nodes representing dataset variables and joins them
to an input ontology network using a mapping file. Prior to joining, the
information content of all nodes is calculated using \code{\link{node_IC_zhou}}.
}
\details{
\itemize{ \item The user-defined mappings between variables in a dataset and
entities/terms in an ontology are provided in an edge table
(\code{var2entity_tbl}). \item A node attribute column, \code{node_category} is
generated to describe if a node is one of "Dataset Variable", "Annotation", or
"Annotation Ancestor".
}
}
\examples{
data(example_ontology)
join_vars_to_ontol(example_ontology, example_mapping_file, root = "root", mode = "in")
}
\seealso{
node_IC_zhou

Other semantic enrichment functions: 
\code{\link{metavariable_agg}()},
\code{\link{metavariable_info}()}
}
\concept{semantic enrichment functions}
