% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC_clean.R
\name{encode_cats}
\alias{encode_cats}
\title{Encode categorical variables using one-hot encoding.}
\usage{
encode_cats(data, ...)
}
\arguments{
\item{data}{A data frame, data frame extension (e.g. a tibble), or a lazy
data frame (e.g. from dbplyr or dtplyr).}

\item{...}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> One or more unquoted
expressions separated by commas. Variable names can be used as if they
were positions in the data frame, so expressions like \code{x:y} can
be used to select a range of variables.}
}
\value{
Tibble with converted variables.
}
\description{
Variables specified in \code{...} are replaced with new variables describing
the presence of each unique category. Generated variable names have space
characters replaced with "_" and commas are removed.
}
\examples{
require(magrittr)
require(dplyr)

data(example_data)

# encode one variable
encode_cats(example_data, marital_status) \%>\%
select(starts_with("marital_status"))

# encode multiple variables
encoded <- encode_cats(example_data, diabetes, marital_status)

select(encoded, starts_with("marital_status"))
# diabetes_type included below but was not modified:
select(encoded, starts_with("diabetes")) 
}
