% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap_add_cluster_graph.R
\name{add_cluster_graph}
\alias{add_cluster_graph}
\title{Constructs a trajectory using a cell grouping and a network between groups. Will use an existing grouping if it is present in the dataset.}
\usage{
add_cluster_graph(
  dataset,
  milestone_network,
  grouping = NULL,
  explicit_splits = FALSE,
  ...
)
}
\arguments{
\item{dataset}{A dataset created by \code{\link[=wrap_data]{wrap_data()}} or \code{\link[=wrap_expression]{wrap_expression()}}}

\item{milestone_network}{A network of milestones.}

\item{grouping}{A grouping of the cells, can be a named vector or a dataframe with \emph{group_id} and \emph{cell_id}}

\item{explicit_splits}{Whether to make splits specific by adding a starting node. For example: A->B, A->C becomes A->X, X->B, X->C}

\item{...}{extra information to be stored in the wrapper.}
}
\value{
The dataset object with trajectory information, including:
\itemize{
\item \emph{milestone_ids}: The names of the milestones, a character vector.
\item \emph{milestone_network}: The network between the milestones, a dataframe with the \emph{from} milestone, \emph{to} milestone, \emph{length} of the edge, and whether it is \emph{directed}.
\item \emph{divergence_regions}: The regions between three or more milestones where cells are diverging, a dataframe with the divergence id (\emph{divergence_id}), the milestone id (\emph{milestone_id}) and whether this milestone is the start of the divergence (\emph{is_start})
\item \emph{milestone_percentages}: For each cell its closeness to a particular milestone, a dataframe with the cell id (\emph{cell_id}), the milestone id (\emph{milestone_id}), and its \emph{percentage} (a number between 0 and 1 where higher values indicate that a cell is close to the milestone).
\item \emph{progressions}: For each cell its progression along a particular edge of the \emph{milestone_network}. Contains the same information as \emph{milestone_percentages}. A dataframe with cell id (\emph{cell_id}), \emph{from} milestone, \emph{to} milestone, and its \emph{percentage} (a number between 0 and 1 where higher values indicate that a cell is close to the \emph{to} milestone and far from the \emph{from} milestone).
}
}
\description{
A trajectory in this form will rarely be useful, given that cells are only placed at the milestones themselves, but not on the edges between milestones. A better alternative might be to project the cells using a dimensionality reduction, see \code{\link[=add_dimred_projection]{add_dimred_projection()}}.
}
\examples{
library(tibble)
dataset <- wrap_data(cell_ids = letters)

milestone_network <- tibble::tibble(
  from = c("A", "B", "B"),
  to = c("B", "C", "D"),
  directed = TRUE,
  length = 1
)
milestone_network
grouping <- sample(c("A", "B", "C", "D"), length(dataset$cell_ids), replace = TRUE)
grouping
trajectory <- add_cluster_graph(dataset, milestone_network, grouping)

# for plotting the result, install dynplot
#- dynplot::plot_graph(trajectory)
}
\keyword{create_trajectory}
