% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_orient_topology.R
\name{orient_topology_to_velocity}
\alias{orient_topology_to_velocity}
\title{Reorients the edges of the milestone network to the cell's RNA velocity vectors}
\usage{
orient_topology_to_velocity(trajectory,
  expression = trajectory$expression,
  expression_projected = trajectory$expression_projected)
}
\arguments{
\item{trajectory}{The trajectory as created by \code{\link[=infer_trajectory]{infer_trajectory()}} or \code{\link[=add_trajectory]{add_trajectory()}}}

\item{expression}{The normalised expression values of genes (columns) within cells (rows). This can be both a dense and sparse matrix.}

\item{expression_projected}{Projected expression using RNA velocity of genes (columns) within cells (rows).  This can be both a dense and sparse matrix.}
}
\value{
The trajectory with oriented \emph{milestone_network} and \emph{progressions}
}
\description{
Reorients the edges of the milestone network to the cell's RNA velocity vectors
}
\examples{
# we'll create a simple linear trajectory
cell_ids <- c("a", "b", "c", "d", "e")
pseudotime <- setNames(seq_along(cell_ids), cell_ids)
expression <- as.matrix(data.frame(
  a = pseudotime,
  b = pseudotime ** 2,
  c = log(pseudotime)
))
expression_projected <- as.matrix(data.frame(
  a = (pseudotime + 1),
  b = (pseudotime + 1) ** 2,
  c = log(pseudotime + 1)
))

# the milestone network is "wrong" in the sense that B and A are oriented in the opposite direction
milestone_network <- tibble::tribble(
  ~from, ~to, ~length, ~directed,
  "B", "A", 1, TRUE,
  "B", "C", 1, TRUE
)
progressions <- tibble::tribble(
  ~cell_id, ~from, ~to, ~percentage,
  "a", "B", "A", 1,
  "b", "B", "A", 0.5,
  "c", "B", "A", 0,
  "d", "B", "C", 0.5,
  "e", "B", "C", 1
)

trajectory <- wrap_expression(
  counts = expression,
  expression = expression,
  expression_projected = expression_projected
)
trajectory <- add_trajectory(
  trajectory,
  milestone_network = milestone_network,
  progressions = progressions
)

trajectory_oriented <- orient_topology_to_velocity(trajectory)

# the edge is now correctly oriented
trajectory_oriented$milestone_network
assertthat::assert_that(
  all(
    trajectory_oriented$milestone_network[2, c("from", "to")] == c("B", "C")
  )
)

}
