% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{coef.splineCox}
\alias{coef.splineCox}
\title{Extract Coefficients from Spline Base Cox Model}
\usage{
\method{coef}{splineCox}(object, ...)
}
\arguments{
\item{object}{An object returned by function \code{splineCox}.}

\item{...}{Optional arguments. Currently, the only applicable arguemnt is
\code{level} for the credible level. The default value is 0.95.}
}
\value{
A data.frame with 6 columns \code{("Low", "Mid", "High", "Time",
    "Cov", "Model")}, where \code{"Mid"} is the point estimates;
    \code{"Low"} and \code{"High"} are the point estimates plus and minus
    1.96 times standard deviations (under default level); \code{"Cov"} and
    \code{"Model"} contain character values of the covariates and model
    type.
}
\description{
Extract coefficient values from \code{splineCox} fitting results, and
summarize the point estimate and 95\% confidence band into a data frame.
}
\note{
It essentially expand the break points, and then call function
    \code{coxph} in package \code{survival}
}
\examples{
## See the examples in splineCox.
}
\seealso{
\code{\link{splineCox}}, and \code{\link{plotCoef}}.
}
\keyword{coefficient}
\keyword{extract}
\keyword{splineCox}
