% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{coef.bayesCox}
\alias{coef.bayesCox}
\title{Extract Coefficients from Bayesian Cox Model}
\usage{
\method{coef}{bayesCox}(object, ...)
}
\arguments{
\item{object}{An object returned by function \code{bayesCox}.}

\item{...}{Optional arguments. Currently, the only applicable arguemnt is
\code{level} for the credible level. The default value is 0.95.}
}
\value{
A data.frame with 6 columns \code{("Low", "Mid", "High", "Time",
"Cov", "Model")}, where \code{"Low"} and \code{"High"} are the posterior
2.5\% and 97.5\% quantiles as default; \code{"Mid"} is the posterior mean;
\code{"Cov"} and \code{"Model"} contain character values of the covariates
and model types.
}
\description{
Extract coefficient values from \code{bayesCox} fitting results, and
summarize the posterior mean, posterior 2.5\% and 97.5\% quantiles into a
data frame.
}
\examples{
## See the examples in bayesCox.
}
\seealso{
\code{\link{bayesCox}}, and \code{\link{plotCoef}}.
}
\keyword{bayesCox}
\keyword{coefficient}
\keyword{extract}

