% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_milestone_coloring.R
\name{add_milestone_coloring}
\alias{add_milestone_coloring}
\title{Add colouring to a set of milestones.}
\usage{
add_milestone_coloring(
  milestones = NULL,
  color_milestones = c("auto", "given", "cubeHelix", "Set3", "rainbow")
)
}
\arguments{
\item{milestones}{Tibble containing the column \code{milestone_id} (character).
If \code{color_milestones} is set to \code{"given"}, this tibble should also contain a column
\code{color} (character), containing colour hex codes (e.g. \code{"#123456"}).}

\item{color_milestones}{Which palette to use for colouring the milestones
\itemize{
\item \code{auto}: Determine colours automatically. If \code{color} is already specified in
milestones tibble, this will be used. Otherwise, the colour scheme is determined by
\code{milestone_palette_list$auto}.
\item \code{given}: The \code{milestones} object already contains a column \code{color}.
\item \code{cubeHelix}: Use the \code{rje::cubeHelix()} palette.
\item \code{Set3}: Use the \code{RColorBrewer::brewer.pal(name = "Set3")} palette.
\item \code{rainbow}: Use the \code{grDevices::rainbow()} palette.
}}
}
\value{
A tibble containing the input character column \code{milestone_id} and a character
column \code{color} containing colour hex-codes (e.g. \code{"#123456"}).
}
\description{
Add colouring to a set of milestones.
}
